!Fussbudget Vocabulary:
!lotsa, whaddya, outta, gonna, gimme, lemme, wanna, hey, huh, ya, yeah,
!ougtha, 'em, c'mon, dumb, getta, you bet!

Constant reset             0;
Constant tried_locked_door 1;

Global Eat_tube = 0;

Followclass Fussbudget "Fussbudget" Cage
  with
    name "fussbudget" "fuss" "budget" "alien" "animal" "sidekick" "thoosian"
         "thosian-fussbudget" "creature" "body" "shell",
    status reset,
    initial
    [;if ((Fussbudget in Sickbay) && (Fussbudget hasnt awake))
        "The Fussbudget is snoring loudly in the corner.";
      "The Fussbudget is here.";
    ],
    description 
    [;print "Thoosian Fussbudgets are famous for eating, sleeping, and 
      having a bad attitude. This one has more appendages than a football
      team, and looks like a cross between E.T. and a caterpillar. Judging
      from its compact structure, it appears to have evolved on a 
      high-gravity planet. It has a body shell that looks very like a 
      scorpion's. ";

      if (self has awake) print "It seems to be awake. ";
      else print "It seems to be asleep. ";       

      if (Bracelet in self)    
        print "It is wearing ", (a) Bracelet, ".";

      if (Credit_Card in self) 
        "It has ", (a) Credit_Card, " and ", (a) OXO, ".";
      "It has ", (a) OXO, ".";
    ],
    before
    [;Break, BreakWith, Cut, CutWith: 
      if (Fussbudget hasnt awake)
        "You'd better wake it up first.";
      print "", (The) Fussbudget, " squeals and says, ~I'm not in ", 
             (the) Lab, " now.~"; 
      if (Location==Lab) 
        print " Then it looks around scratching its head and says ~Well maybe
               I am, but ya still not doing that to me.~";
      "";
      Taste: "You want to catch some dangerous alien disease?";
      Take:
      if (Fussbudget has awake)
      { 
        if (Fussbudget in Cage)
          "I don't think it will fit through the bars.";
        if ((Location==Hall_l) && (Bracelet in Fussbudget))
          "You can't see any such thing!";  
        "You try to get a grip on ", (the) Fussbudget, " but it slithers
         around so much you can't keep hold. ~That'll teach ya~ gloats ",
         (the) Fussbudget, ".";
      }
      else
        "You'd better wake it up first.";
      Drop:
        if ((Location==Hall_l) && (Bracelet in Fussbudget))
          "You can't see any such thing!";  
      Play: 
      if (Fussbudget has awake)
      { 
        "", (The) Fussbudget, " says, ~I no longer feel the need to play
         childish games, but I'm always up for a game of noughts and 
         crosses, 'specially when I getta go first.~";
      }
      else
        "You'll have to wake it up first.";
      Shake: <<WAKEOTHER SELF>>; 
      ShakeHands: 
      if (Fussbudget has awake)
      { 
        spacetime=spacetime+100;
        if (Fussbudget in Cage) 
          print "It reaches some of its hands through the cage bars. ";
        "", (The) Fussbudget, " insists you shake each and every one of its
         hands. Many chrons later, you finally complete the epic task. These
         creatures must spend more time at parties greeting each other than
         partying.";
      }
      else
        "You'll have to wake it up first.";
    ],
    daemon 
    [;if ((Fussbudget notin Location) && (Location ~= lf_loc)) 
      {
        lf_loc_but_one = parent(Fussbudget);
        move Fussbudget to Location;
        lf_loc = Location;
      
        if (Location == Hall_n) give Hall_n general;

        if ( (Location == Hall_l) && (Store hasnt visited) &&
        (Fussbudget hasnt Scenery) && ( (Bracelet in Player) || 
        ((Bracelet in Toolbox) && (Toolbox has Open)) ) )
        {
          give Fussbudget ask_bracelet;
          "The Fussbudget gangles after you. It suddenly notices your 
           identity bracelet. ~Hey, a bracelet. If you gimme it, I can get 
           us lotsa food, whaddya say, huh?~";
        }
        else if (Location == Lab)
          "", (The) Fussbudget, " hesitates, then gingerly enters the room, 
          muttering something about having spent too long in this place 
          doing dumb experiments already.";
        else if ((Location == Hall_l) && (lp_loc_but_one == Store)
        && (Fruit in Store))
          "", (The) Fussbudget, " spots the break in the barrier, then looks 
          back at ", (the) fruit, ". You can see it is torn between whether 
          to eat the mondoweed fruits and be stuck in ", (the) store, " or 
          escape and leave its prize. Just as ", (the) barrier, 
          " is about to reform it dashes after you saying ~See Bud, 
          I didn't steal the fruit, you can trust me~, and winks.
          It's quite a sight seeing all those legs going at such 
          a speed in ", (the) Fussbudget, "'s peculiar rhythmic gait.";
        else if ( (Location == Store) || 
        ((Location == Hall_l) && (lp_loc_but_one == Store)) )
          "", (The) Fussbudget, " spots the break in the barrier and dashes 
          after you knowing ", (the) barrier, " can't reform  
          while something is interrupting it. 
          It's quite a sight seeing all those legs going at
          such a speed in ", (the) Fussbudget, "'s peculiar rhythmic gait.";
        else if ((Location == Hall_j) && (lf_loc_but_one == TransporterPad))
          "", (The) Fussbudget, " jumps off ", (the) TransporterPad, 
          " and gangles after you.";
        else if ((lp_loc == lf_loc) && (Fussbudget hasnt Scenery))
          "The Fussbudget gangles after you.";
      }

      if ((parent(Fussbudget) == Location) && (Fussbudget hasnt Scenery))
      {
        switch (random(100)) 
        {
          1: "The Fussbudget shivers. ~Does it seem chilly in here? I
              hate drafty places.~ A look of concern crosses its face.
              ~Do you think the heating units have failed?~";
          2: if ((Fussbudget notin Sickbay) && (Fussbudget notin Store))
             {
               give self ~awake; 
               StopDaemon(self);

               if ((Fussbudget in Scooter) && (Hatch hasnt Open))
               {
                 move Fussbudget to Sickbay;
                 give Hatch Open;
                 "The Fussbudget says, ~See ya later, Bud. I'm gonna go
                  catch some winks.~ It opens the hatch and gangles out.";
               }
               else
               {
                 move Fussbudget to Sickbay;
                 "The Fussbudget says, ~See ya later, Bud. I'm gonna go
                  catch some winks.~ It gangles out.";
               }
             }
          3: print "", (The) Fussbudget, " yawns, saying, ~I'm bored; want a 
                    game of noughts and crosses?~ [Yes/No] ";
             if (YesOrNo()~=0) <<PLAY OXO>>;
             print "~Come on, we're Buds, aren't we?~ [Yes/No] ";
             if (YesOrNo()~=0) <<PLAY OXO>>;
             "It says, ~OK suit yourself~, and goes off for a sulk.";
        }
      }   
    ],
    orders 
    [;Open:
      switch (noun)
      {
        Stall: 
          "~Thankfully my biological functions are considerably different to
           yours~, says ", (the) Fussbudget, "."; 
        Cage:
          if (self has awake)
          {
            if (Fussbudget in Cage)
              "~Do you really think I'd be in here if I could open du cage~,
               says ", (the) Fussbudget, "."; 
            "~Who cares about that thing, I'm free now~, complains ", 
             (the) Fussbudget, " jumping gleefully around the room.";
          }
          "", (The) Fussbudget, " just snores in reply.";
        Hatch:
          if (hatch hasnt open)
          {
            give Hatch open;
            "~Aye, Aye Cap'in~ says the fussbudget opening the hatch and
              saluting with a half dozen feet. The hatch is now open.";
          }
          "~Duh! It's already open, bud.~";
        Hab_Bulkhead:
          if (Hab_Bulkhead hasnt open)
            "~No way, it might be dane-g-o-us. YOU'VE got the pips. YOU open
             the bulkhead!~";
          "~Duh! It's open already~, says ", (the) Fussbudget, ".";
        Eng_Bulkhead:
          if (Eng_Bulkhead hasnt open)
            "~No way, it might be dane-g-o-us. YOU'VE got the pips. YOU open
             the bulkhead!~";
          "~Duh! It's open already~, says ", (the) Fussbudget, ".";
        Dentist_Door:
          if  (Dentist_Door hasnt open)
          {
            enter_dentist (); rtrue;
          }
          "~Duh! It's open already~, says ", (the) Fussbudget, ".";
      }

      Close:
      switch (noun)
      {
        Stall:
          "~Duh! I'm not in du stall.~"; 
        Cage:
          if (self has awake)
            "~Duh! It's closed already~, says ", (the) Fussbudget, ".";
          "", (The) Fussbudget, " just snores in reply.";
        Hatch:
          if (hatch has open)
          {
            give Hatch ~open;
            "~Aye, Aye Cap'in~ says the fussbudget closing the hatch and
             saluting with a half dozen feet. The hatch is now closed but the
             fussbudget gives it a kick for good measure.";
          }
          "", (The) Fussbudget, " doesn't look where its going and bumps into
           the closed hatch complaining, ~It's closed. Nice of ya to tell
           me.~";
        Hab_Bulkhead:
          if (Hab_Bulkhead has open)
            "~What? After all the trouble we went to to open it?~, moans ",
             (the) Fussbudget, ".";
          "~Duh! It's closed already~, says ", (the) Fussbudget, ".";
        Eng_Bulkhead:
          "~Duh! It's closed already~, says ", (the) Fussbudget, ".";
        Dentist_Door:
          if (Dentist_Door has open)
          {
            give Dentist_Door ~open;
            "", (The) Fussbudget, " gangles over to the door giving it a good
             kick with several of it legs and it slams shut.";
          }
          "~Duh! It's closed already~, says ", (the) Fussbudget, ".";
      }

      Wear:
      switch (noun)
      {
        Maze:
          "", (The) Fussbudget, " says, ~I can't wear ", (the) Maze,
          " but I bet I could wear ", (the) Headset, ".~";
        Headset:
          play_maze (); rtrue;
      }

      Use: 
      switch (noun)
      {
        Stall:
          "~Thankfully my biological functions are considerably different to
           yours~, says ", (the) Fussbudget, ".";
        Maze, Headset: 
          play_maze (); rtrue;
        Teleport, ControlPanel:
          spacetime = spacetime + 13; 
          "", (The) Fussbudget, " raises an eyebrow and says, ~Do I look 
          like a cloth eared Irishman?~ Then ruminates for a few 
          chrons and says, ~I dare say I could push the button 
          though.~";
        TeleportButton: push_teleport_button (); rtrue;
      }

      Push: if (noun==TeleportButton) 
            { push_teleport_button (); rtrue; }   
            "", (The) Fussbudget, " says, ~Do it yourself, Bud!~";

      Take:
      if (((noun==Maze) || (noun==Headset)) && (Location == Lab))
      {
        play_maze ();
        rtrue;
      }

      Play:
      switch (noun)
      {
        Maze, Headset:
          play_maze ();
          rtrue;
        OXO:
          play_OXO ();
          rtrue;
        default: "That isn't a game.";   
      }
 
      Go: if (self has awake)
          {
            if (self in cage)
              "~Lemme outta the cage first.~ says ", (the) Fussbudget, ".";
            if (  (self notin waiting_room) || 
               ((self in waiting_room) && (noun~=port_obj)) )
              "~What's the point of going in that direction?~ says ",
               (the) Fussbudget, ".";
            enter_dentist (); rtrue;
          }
          "", (The) Fussbudget, " just snores in reply.";
        
      Enter:
      if (self hasnt awake) "", (The) Fussbudget, " just snores in reply.";
          
      switch (noun) 
      {
        Stall:
          "~Thankfully my biological functions are considerably different to
           yours~, says ", (the) Fussbudget, ".";
        TransporterPad:
          if (Fussbudget in TransporterPad)
            "", (The) Fussbudget, " is already on ", (the) TransporterPad, 
            ".";
          move Fussbudget to TransporterPad;
          "", (The) Fussbudget, " dashes to the pad, not giving a thought
           to how you're going to get off the station without anyone to
           operate the teleport for you, and says grinning, ~Beam me down
           spotty!~";
        Dentist_Door:
          enter_dentist (); rtrue;
        default:
          "", (The) Fussbudget, " says, ~Do it yourself, Bud!~";
      }      

      GetOff:
      if (self hasnt awake) "", (The) Fussbudget, " just snores in reply.";

      switch (noun)
      {
        Stall:
          "~Duh! I'm not in du stall.~"; 
        Cage:
          if (Fussbudget in Cage)
            "", (The) Fussbudget, " shakes the bars and says, ~Do you really
            think I would be in here if I could get out by myself?~";
          else
            "", (The) Fussbudget, " isn't in ", (the) Cage, "."; 
        TransporterPad:
          if (Fussbudget notin TransporterPad)
            "", (The) Fussbudget, " isn't on ", (the) TransporterPad, ".";
          move Fussbudget to TeleportRoom;
          "", (The) Fussbudget, " gets off ", (the) TransporterPad,
          " complaining ~When du I get outta here?~";
        default:
          "", (The) Fussbudget, " says, ~Do it yourself, Bud!~";
      }

      Exit:
      if (self hasnt awake) "", (The) Fussbudget, " just snores in reply.";
      
      if (Location==TeleportRoom)
      {
        if (Fussbudget notin TransporterPad)
          "", (The) Fussbudget, " isn't on ", (the) TransporterPad, ".";
        move Fussbudget to TeleportRoom;
        "", (The) Fussbudget, " gets off ", (the) TransporterPad,
        " complaining ~When do I get outta here?~";
      }
      if (Location==SickBay)
      {
        if (Fussbudget in Cage)
          "", (The) Fussbudget, " shakes the bars and says, ~Do you really
           think I would be in here if I could get out by myself?~";
        else
          "", (The) Fussbudget, " isn't in ", (the) Cage, ".";
      }
      if (Location==CM_SanFac)
        "~Duh! I'm not in du stall.~"; 
      "", (The) Fussbudget, " says, ~Do it yourself, Bud!~";
      
      Hello: 
      if (self hasnt awake) "", (The) Fussbudget, " just snores in reply."; 
 
      if (Hall_n has General)
        "~Hey, if you wan'ed a proper introduc'ion you should have asked
         earlier when we meet.~"; 
   
      print "~Hi Bud, got any food?~ asks ", (the) Fussbudget, 
            ". ~Better shake hands I suppose.~ "; 

      <<SHAKEHANDS FUSSBUDGET>>;       

      Give:
      if (self hasnt awake) "", (The) Fussbudget, " just snores in reply.";

      switch (noun)
      {
        Bracelet:
          move Bracelet to Player;
          move Fussbudget to Store;
                
          if (Fussbudget has eating)
            "Without looking up or pausing for a second, ", (the) 
             Fussbudget, " tosses you the bracelet.";
          "", (The) Fussbudget, " tosses you the bracelet.";

        Credit_Card:        
          move Credit_Card to Player;
          "A look of disappointment passes over ", (the) Fussbudget,
          "'s face, reluctantly it gives ", (the) Credit_Card, " back. 
           And you thought it didn't have a conscience.";        

        OXO:
          "", (The) Fussbudget, " cluches its ", (name) OXO, 
          " saying ~Your not having this!~";
      }

      NotUnderstood:    
      spacetime = spacetime + 6;
      if (self hasnt awake) "", (The) Fussbudget, " just snores in reply.";
      if ((etype == CANTSEE_PE) && (verb_word == 'give'))
        "~I'm not carrying that!~ complains ", (the) Fussbudget, ".";
      "", (The) Fussbudget, " says, ~Do it yourself, Bud!~";
       
      default:
      spacetime = spacetime + 6;
      if (Fussbudget has awake) 
        "", (The) Fussbudget, " says, ~Do it yourself, Bud!~";
      "", (The) Fussbudget, " just snores in reply.";
    ],
    life   
    [;
    Order: 
    if (action==##Take)
    {
      if (noun==hosing)
      {
        if (self has awake)
        {
          if (player hasnt visited_dentist)
            "You haven't seen any such thing.";
          if (fussbudget hasnt visited_dentist)
            "", (The) Fussbudget, " asks ~Where du I find that?~";
          "~I've already got that for ya.~ says ", (the) Fussbudget, ".";
        }
        "", (The) Fussbudget, " just snores in reply.";
      }
        
      if (noun==bits)
      {
        if (self has awake)
        {
          if (player hasnt visited_dentist)
            "You haven't seen any such thing.";
          if (fussbudget hasnt visited_dentist)
            "", (The) Fussbudget, " asks ~Where du I find that?~";     
          "", (The) Fussbudget, " says, ~I'm not touching that stuff, it's 
          dane-g-o-us, I might get elec-tri-cutted!~";
        }
        "", (The) Fussbudget, " just snores in reply.";
      }
    }    

    Ask: 
    if (fussbudget hasnt awake) "The Fussbudget just snores in reply.";
         
    switch (second)
    {
      'nuclear', 'reactor':
        "", (The) Fussbudget, " says, ~They don't lemme near that thing and
         even if they did I wouldn't go. I may have more than the usual
         number of arms and legs but that doesn't mean I want two heads as
         well!~";
      'fussbudget', 'fuss', 'budget', 'alien', 'animal', 'sidekick',
      'thoosian', 'thosian-fussbudget', 'creature', 'body', 'shell':
        "", (The) Fussbudget, " says, ~Shucks, I don't like to talk 'bout me
         self, ya know.~ It almost looks embarrassed. But then it can't
         resist adding, ~But I'm cool dude, aren't I?~";
      'space', 'station', 'spacestation':
        "", (The) Fussbudget, " says ~Gee it's so big, but they don't lemme
         out of the sick bay except when I have to do dumb experiments for
         them in du Lab. Then lotsa important visitors come to see me. Most
         of them are fat and bald.~";
      'sick', 'bay', 'sickbay', 'steel', 'cage':
        "~Dull. Dull. Dull. Get du picture.~";
      'heat', 'heating', 'unit', 'units': 
        "", (The) Fussbudget, " says, it's usually a lot warmer round 
         here, may be there's a problem with the power. We had better 
         find an Engineer, you can never be to careful in space!";
      'noughts', 'and', 'crosses', 'tic', 'tac', 'toe', 
      'tic-tac-toe', 'tictactoe', 'game', 'paper', 'pencil':
         print "", (The) Fussbudget, " says, ~Great game, let's play.~^";
         <<PLAY OXO>>; 
      'dentist', 'dentists', 'dentist^s':
        "", (The) Fussbudget, " says, ~They ain't scary, not for a 
         tough dude like me.~ It smiles revealing a mouth full of 
         metal that would put 'jaws' to shame.";
      'lab', 'laboratory', 'xeno', 'biology':
        "", (The) Fussbudget, " grimaces saying, ~Just don't ask me 'bout
         the maze in there.~";
      'virtual', 'maze', 'black', 'box':
        if (Lab has visited) 
          "", (The) Fussbudget, " says, ~Not much to it, really. Just
           a lot of twisty little paths. I was hoping to find a 
           treasure chest at the end, but there was just this stupid
           vending machine. Those eggheads had me running that thing
           for ages like I'm a rat or some'ing.~";
        "You haven't seen any such thing.";
      default:
        "The Fussbudget doesn't seem to know much about this subject.";
    }

    Tell: if (fussbudget has awake)
          {
            switch (second)
            {
              'space', 'scooter', 'teleport', 'transporter':
                "~Lets get outta here, I'm sick of this dumb station and it's
                 dane-g-o-us. I want to go home and see all my buds. It's 
                 mondoweed fruit season and I can't miss that.~ It says
                 licking its lips. ~You're smart, you can work out how to get
                 us outta here.~";
              'tube', 'of', 'paste', 'nutrient', 'nutrient-paste':
                "You tell ", (the) Fussbudget, " about ", (the) Paste,
                ". Its eyes light up, ~Gee, anchovy and peanut butter.
                 Gimme a taste.~ Some how you think its going to want more
                 than 'a taste'.";
              'reactor', 'explosion', 'melt', 'down': 
                if (computer has read7)
                  "You tell ", (the) Fussbudget, " that the reactor is about
                   to meltdown. It says, ~Let's get off this hunk of metal, 
                  P.D.Q.~";
                else
                  "You don't know about that.";
              'dentist', 'dentists', 'dentist^s':
                if (player has visited_dentist)
                {
                  print "You tell ", (the) Fussbudget, " about all the stuff 
                  in the dentist and how you are afraid to go in there. ", 
                  (The) Fussbudget, " says, ~I ain't scared of dentist's, I 
                  ain't scared of nu'ing, I can get the stuff for ya if ya 
                  want";
                  if (Fussbudget in Cage)
                    print ", but first you've gotta get me outta this cage";
                  ".~";
                }
            }
            "The Fussbudget doesn't seem interested in that subject.";
          }
          else "The Fussbudget just snores in reply.";
    Give, Show: 
    if (self hasnt awake) "You will have to wake it up first.";

    switch (noun)
    {
      DietCola, EmptyDiet:
        "~I never drink that stuff, it tastes like hydraulic fluid. Yuk!~";

      StandardCola:
        if (Fussbudget in Cage)
          "~Lemme outta du cage first!~, pleads ", (the) Fussbudget, ".";
        else
        {
          remove StandardCola;
          move EmptyStandard to Location;
          give EmptyStandard general;
          spacetime = spacetime + 21;
          "", (The) Fussbudget, " grabs the can, and the contents disappear
           in millicrons. It says, ~They must think people are really dumb, 
           paying extortionate prices for that krip, just because it comes 
           out of a machine.~, it then throws the empty can to the deck. You
           didn't see ", (the) Fussbudget, " complaining when it was drinking
           it though, did you?";
        }                 

      EmptyStandard:
        if (Fussbudget in Cage)
          "~Lemme outta du cage first!~, pleads ", (the) Fussbudget, ".";
        else
        {
          remove EmptyStandard;
          move CrushedCan to Location;
          "", (The) Fussbudget, " grabs the can, weighs it, realizes it's 
          empty, crushes it, and throws it to the deck, saying ~You aren't 
          going to fool me again with that one!~";
        }

      CrushedCan: "~Keep it.~";

      Key:
        if (Fussbudget in Cage)
        {
          "A look of frustration passes over ", (the) Fussbudget, "'s face.
           ~Don't give me the key, try it in the lock!~";
        }
        else
        {
         if ( (self.status & tried_locked_door == tried_locked_door) && 
              (Location == Waiting_Room) && (Fussbudget in Waiting_Room) && 
              (Fussbudget hasnt visited_dentist) )
         {
           give dentist_door ~locked;
           print "", (The) Fussbudget, " grabs ", (the) key, " and unlocks
                  the door, throwing the key back too you, moaning ~You could
                  have done that.~ ";
           enter_dentist (); rtrue;
         }
         "", (The) Fussbudget, " says, ~Duh! I'm free now.~";
        }
      
      Headset:
        play_maze (); rtrue;
 
      Hacksaw:
        "", (The) Fussbudget, " says, ~My hands aren't suited to humanoid 
        instruments.~";

      Credit_Card:
        move credit_card to fussbudget;
        "", (The) Fussbudget, "'s face lights up, and it grabs the card, 
        saying ~Oh Boy, with this I could buy me enough food to last a 
        life time.~";

      ID_Card:
        "", (The) Fussbudget, " examines ", (the) ID_Card, " and says, ~Core,
        aren't you a big cheese.~";
        
      Isotopes:
        "", (The) Fussbudget, " puts on a snotty accent on and says, ~I'm 
        not partial to radioactive isotopes old bean.~";
        
      Fruit:
        if (Fussbudget in Cage)
          "~Lemme outta du cage first!~, pleads ", (the) Fussbudget, ".";
        else
        {
          remove Fruit;
          move Crate to Location;
          spacetime = spacetime + 21;
          "", (The) Fussbudget, " grabs the crate, greedily devours all
          the mondoweed fruits, and then throws it to the deck.
          ~Thanks Bud.~";
        }
          
      Crate:
        "~It's empty, bet it would make a great container~, says ",
        (the) Fussbudget, ".";

      Paste: 
        remove Paste;
        move Tube to Location;
        Eat_tube++;
        "", (The) Fussbudget, " grabs the tube, wildly squeezes it with
        all six hands, greedily devours all the paste, and then 
        throws the empty tube to the deck. ~Gee thanks, got any
        thing else to eat?~";

      Tube: 
        Eat_tube++;

        if (Eat_tube <= 3)
        {
          move Tube to Location;
  
          print (The) Fussbudget, " grabs the tube, wildly squeezes it with
                all six hands, and then throws it to the deck. ~Empty! If I
                don't eat something soon I'll get sick.~";
        }

        switch (Eat_tube)
        {
          1: ;
          2: print " A strange expression passes over ", (the) Fussbudget, 
                   "'s face, perhaps it's thinking? It says, ~You didn't 
                    think I'd fall for that old empty tube trick did
                    you?~, and laughs rather unconvincingly.";
          3: print " A strange expression passes over ", (the) Fussbudget, 
                   "'s face, perhaps it's thinking? It says, ~You didn't 
                     think I'd fall for that old empty tube trick again did
                     you?~, and laughs rather unconvincingly.";
          default: "~I'm not that stupid!~ says ", (the) Fussbudget;
        }
   
        "";
        
      Bracelet: 
        if ((Fussbudget has ask_bracelet) 
        && (Location ~= store) && (Fruit in Store))
        {
          if (Bracelet has worn)
          {
            give Bracelet ~worn;
            print "(first removing ", (the) bracelet, ")^";
          }

          move Bracelet to Fussbudget;
          move Fussbudget to hall_l;
          give Fussbudget scenery;
          give Fussbudget eating;
          StopDaemon(self);
          eattime = spacetime + 28;

          if (Location == hall_l)
            "The Fussbudget grabs the bracelet and dashes forward."; 
          else
            "The Fussbudget grabs the bracelet and dashes off.";
        }
    }

    WakeOther:
        if (self has awake)
        {
          if ((Fussbudget has Scenery) && (Fussbudget notin Cage)) 
            "", (The) Fussbudget, " is behind the barrier!";
          else
            "", (The) Fussbudget, " says, ~Quit poking me, I'm awake
             already!~";
        }
        else
        { give self awake; 
          if (Fussbudget in cage)
          {
            print "It jumps to its feet, all twelve of them. ~Hey, what's
                   going on? Who are you? Lemme outta here!~";
            if (bars_cut == 2)
            {
              print " The Fussbudget sees the gap, squeezes through the cut
              bars, and leaps to the floor. ~Thanks, Bud. By the way, I'm a
              Fussbudget.~ It hops across the room and pokes four or 
              five eye stalks cautiously through the doorway. ~Where is
              everyone?"; 
              free_fussbudget();   
              rtrue;
            }       
            "";
          }  
          else 
          {
            lf_loc = Location;
            StartDaemon(self);
            "~Solved the game yet?~";
          }  
        }
    ],
    has transparent animate neuter;

Object Legs "appendages" Fussbudget
  with
    name "appendage" "appendages" "leg" "legs" "stork" "storks"
         "arm" "arms" "eye" "eyes",
    description "You start counting the Fussbudget's eye storks, legs, and
                 arms, but keep losing count, as there are so many of them.",
    has concealed static;

[ push_teleport_button;
  if (TeleportButton has general)
    "", (The) Fussbudget, " says, ~We've tried that already. We'd better find
     another way of the station.~";
  if (Fussbudget in TransporterPad)
    "", (The) Fussbudget, " says, ~I can't reach the button from here 
    'brains' .~";
  if (Player in TransporterPad)
  {
    give TeleportButton general;
    spacetime = spacetime + 13;
    "", (The) Fussbudget, " quotes from a book by an early Sol author:
    ~It is a far far better thing that I do than I have    
    ever done before~, and pushes the button...^^
    You hear a recorded voice. ~Insufficient energy to operate 
    teleport as main reactor is off line, and all systems are 
    running on backup batteries.~^^
    There follows a rather embarrassing silence when you both realize 
    you're going nowhere.";
  }
  <<PUSH TELEPORTBUTTON>>;
];

[ play_maze;
  spacetime=spacetime+43;
  "", (The) Fussbudget, " takes ", (the) headset, " and puts it on its
   head; it seems to fit perfectly. It appears to be concentrating hard,
   and after a while removes ", (the) headset, ", saying with a gleam in its 
   eye, ~Good idea Bud; if ya GOTTA have a maze, at least get the NPC to do 
   it for ya.~", (note) 4;
];

[ free_fussbudget;
  move Fussbudget to Sickbay;
  Achieved(0);
  StartDaemon(Fussbudget);
  if ((Paste in Player) || (Tube in Player))
    " Hey, that looks like a tube of nutrient paste you've got
     there.~";
  else
    "~";
];

Object OXO "pencil and some paper" Fussbudget
  with
    name "noughts" "and" "crosses" "tic" "tac" "toe" "tic-tac-toe" 
         "tictactoe" "game" "paper" "pencil", 
    description
    [; print "^The paper has a lot of previously played noughts and crosses
       on it, and the pencil is worn down with use. Clearly ", (the) 
       Fussbudget, " is a noughts and crosses buff, it's probably too stupid
       or lazy to play proper games."; 
       if ((win~=0) || (draw~=0) || (lose~=0))
         print " The current score according to the paper is You: ",
         win, "  Draws: ", draw, "  Fussbudget: ", lose, ".";
       " ", (note) 5; 
    ],
    before
    [; playwith: if (second == Fussbudget) <<PLAY OXO>>;                
       play:   
       if ( (Fussbudget in Location) ||
       ((Fussbudget in Cage) && (Location == Sickbay)) )
       {
         if (Fussbudget has awake)
         {
           print "", (The) Fussbudget, " produces some paper and a pencil 
           from somewhere about its person, and the game
           begins. ";
           play_OXO (); 
           rtrue;
         }
         else "You'll have to wake ", (the) Fussbudget, " up first, if you 
               want a game.";           
       }        
       else "There isn't anyone here, to play against.";         
    ],
    has concealed;

[ play_OXO;
  spacetime = spacetime + 33;
  switch(random(4))
  {
    1: win++;
       print "You Win";

       if (random(2) == 1) 
         print ", even though ", (the) Fussbudget, " had the advantage of
                going first, and picked the center square";
       print ". The score according to the paper is now You: ", win, 
       "  Draws: ", draw, "  Fussbudget: ", lose, ". ", (The) Fussbudget, 
       " doesn't look very happy, and whines ~Luck, pure Luck. You've GOTTA
       let me have another go!~ [Yes or No?] "; 
       if (YesOrNo()~=0) 
       {
         print "~Great! I'll show you this time.~^";
         play_OXO ();
       }
       else
       {
         "", (The) Fussbudget, " rolls its eyes and says,
          ~Sure, I understand Bud, you're afraid of losing.~ ", 
          (The) Fussbudget, " puts the paper and pencil away.";
       }
    2,3: draw++;
         "It's a draw. I bet that's never happened in a game of noughts and
          crosses before. The score according to the paper is now You: ", 
          win, "  Draws: ", draw, "  Fussbudget: ", lose, ". ", 
          (The) Fussbudget, " puts the paper and pencil away.";
    4: lose++;
       print "", (The) Fussbudget, " wins. The score according to 
       the paper is now You: ", win,  "  Draws: ", draw, "  Fussbudget: ",
       lose, ". ", (The) Fussbudget, " can't conceal its glee, and dances
       about singing  ~I'm smarter than you. I'm smarter than you.~"; 

       if (random(2) == 1)
         print " Even though it had the advantage of going 
                first, and picked the center square.";

       " It doesn't seem particularly
        interested in another game, and puts the paper and pencil 
        away. You wonder whether it really likes noughts and crosses
        that much, or just wanted to get one over on you.";
   }
];

[ enter_dentist;
  if (Fussbudget has visited_dentist)
    "~Hey, I've been in there already, it's boring, and there ain't no 
     food there.~ moans ", (the) Fussbudget, ".";
  if (Dentist_Door hasnt open)
  {
    if (Dentist_Door has locked)
    {
      self.status = self.status | tried_locked_door; 
      "", (The) Fussbudget, " fumbles with ", (the) Dentist_Door, 
      ", but can't seem to get it to open. It says, ~Hey Bud, I 
       think it's locked, but I bet you knew that!~, and then goes 
       off and has a sulk in the corner.";
    }
    else
    {
      give dentist_door open;
      print "", (The) Fussbudget, " fumbles with ", (the) Dentist_Door, 
            ", and finally gets it open. ";
    }
  }
  give Fussbudget visited_dentist;
  spacetime = spacetime + 50;
  move hosing to player;
  achieved(5);
  "It heads port, and enters the dentist's surgery. You hear some 
   alarming noises and things breaking, and it comes back carrying 
   some hosing. It says, ~Just a load of junk in there; want this 
   tubing?~ It chucks the hosing at you, which you luckily manage to 
   catch.";
];