#!/usr/bin/python

import sys
import random

class xor_rand:
    def __init__(self):
        self.x = 23103
        self.y = -29065
    def next(self):
        t = self.x ^ ((self.x * 32) & 0xffff)
        self.x = self.y
        self.y = self.y ^ (((self.y & 0xfffe) / 2) & 0x7fff)
        self.y = self.y ^ (t ^ (((t & 0xfff8) / 8) & 0x1fff))
        return self.y & 0x7fff

def permute(r):
    result = [0]
    for i in range(1,256):
        j = r.next() % (i+1)
        result.append(i)
        result[i] = result[j]
        result[j] = i
    return result

def do_chunk (rand, dat):
    result = []
    for i in range(256):
        result.append(random.randint(0, 255))
    permutation = permute(rand)
    for i in range(len(dat)):
        result[permutation[i]] = ord(dat[i])
        result[permutation[i]] ^= rand.next() % 256
    return result

v = xor_rand()

data = file(sys.argv[1]).read().replace('\n','\r')
origlen = len(data)
while len(data) % 224 != 0:
    data += chr(random.randint(0, 255))
chunks = len(data) / 224

result = []
for i in range(chunks):
    chunk = do_chunk(v, data[i*224:(i+1)*224])
    result.extend(chunk)

i = 0
print "Array victory -> ",

for c in result:
    if i > 0 and i % 16 == 0:
        print "\n       ",
    print c,
    i += 1

print ";"

print "Constant VICTORY_CHUNKS " + str(chunks) + ";"
print "Constant VICTORY_REMAINDER " + str(origlen % 224) + ";"
