package iageserver;
 
import java.awt.*;

/**
 * VDU Class. This is an abstract class (because all it's members are
 * static) which handles transmission of messages to players and output
 * to the main text area on the server screen.
 */
public abstract class vdu {

  /**
   *  Reference to main console textarea. Is set by the
   *  UI screen in mainframe.java.
   */
  public static TextArea out;
  
  /*** Set to true if no UI is required */
  public static boolean consolemode = false;
  
  /**
   *  Reference to list view showing currently connected players.
   */
  public static List connectionlist;

  /**
   *  Outputs the string to all players in the location
   *  specified, excluding the player object passed in.
   */
  public static void TransmitAllInLocation(String mess, player curplayer, long locationid) {
    int i = 1;
    player p = null;
    while (i <= data.oplayers.getCount()) {
    	// Retrieve current player in collection
    	p = (player) data.oplayers.get(i);
    	// If they are in this location and not the player initiating this (curplayer)
    	// - transmit the message to them. If the player passed in is null, send
    	// to all players regardless.
    	if (curplayer == null) {
    		if (p.CurrentLocation == locationid) Transmit(mess, p);
    	}
    	else
    	{
	    	if (p.CurrentLocation == locationid && p.Index != curplayer.Index) {
	    		Transmit(mess, p);	
	    	}
	    }
    	i++;
	}
  }

  /**
   *  Transmits the text to the player passed in.
   *  Checks their mode and transmits HTML or Text.
   */
  public static void Transmit(String mess, player ptotransmitto) {
  	
  	 if(!ptotransmitto.TextOnly) {
	  	// Transmit it
	  	ptotransmitto.socket_outputstream.write("<br>" + mess);
	  	// Flush the buffer to make sure it goes and the client will
	  	// receive it in a neat packet.
	  	ptotransmitto.socket_outputstream.flush();
	  	// Flag the player as transmitted to
	  	ptotransmitto.OutputToPlayer = true;
	 }
	 else
	 {
	 	// Strip html formatting from the string
	 	mess = vdu.replace(mess, "&nbsp;", " ");
	 	mess = vdu.replace(mess, "<br>", "\n");
	 	mess = vdu.removehtml(mess);
	 	
	 	ptotransmitto.socket_outputstream.write("\n" + mess);
	  	// Flush the buffer to make sure it goes and the client will
	  	// receive it in a neat packet.
	  	ptotransmitto.socket_outputstream.flush();
	  	// Flag the player as transmitted to
	  	ptotransmitto.OutputToPlayer = true;
	 }
  }
  
  /**
   *  Transmits the text to all players excluding the player passed in.
   */
  public static void TransmitAllEx(String mess, player ptoexclude) {
  	int i = 1;
    player p = null;
    while (i <= data.oplayers.getCount()) {
    	// Retrieve current player in collection
    	p = (player) data.oplayers.get(i);
    	// If they are not the player initiating this, transmit the message to them.
    	if (p.Index != ptoexclude.Index) {
    		Transmit(mess, p);	
    	}
    	i++;
	}
  }

  /**
   *  Outputs the string to all players in the game.
   */
  public static void TransmitAll(String mess) {
    int i = 1;
    player p = null;
    while (i <= data.oplayers.getCount()) {
      // Retrieve current player in collection
      p = (player) data.oplayers.get(i);
	  Transmit(mess, p);	
	  i++;
	}
  }

  /**
   * Outputs the input string to the main textarea.
   */
  public static void print(String s) {
  	if (consolemode) {
  		System.out.print(s);
  	}
  	else
    {out.append(s);
    out.paintAll(out.getGraphics());
    //out.setCaretPosition(out.getText().length());
	}
  }

  /**
   * Overloaded - println accepts a string and appends
   * the input to the main textarea, followed by a carriage return.
   */
  public static void println(String s) {
  	if (consolemode) {
  		System.out.println(s);
  	}
    else {out.append(s + "\n");
    out.paintAll(out.getGraphics());
    //out.setCaretPosition(out.getText().length());
    }
  }

  /**
   * Outputs a carriage return to the main textarea.
   */
  public static void println() {
  	if (consolemode) {
  		System.out.println();
  	}
  	else
  	{
    out.append("\n");
    out.paintAll(out.getGraphics());}
  }
  
  /**
   *  Reads the player collection and attempts to
   *  fill the list of connected players
   */
   public static void updateconnectionlist() {
   		
   		int i = 1;
   		player p = null;
   		
   		// if we are in console only mode, we can't
   		// do this
   		if (consolemode) return;
   		
   		// wipe the list and rebuild
   		connectionlist.removeAll();
   		
   		while (i <= data.oplayers.getCount()) {
   			
   			p = (player) data.oplayers.get(i);
   			connectionlist.add(Integer.toString(p.Index) + ": " + p.IPAddress + " - " + p.Name);
   			i++;
   		}
   }
  
	public static String replace(String findin, String find, String replacewith) {
	
		String sb = findin;
		int i = 0;
			
		while (i <= sb.length() - find.length()) {
			if (sb.substring(i, i + find.length()).equalsIgnoreCase(find)) {
				
				StringBuffer nsb = new StringBuffer(sb);
				sb = vdu.stringbuffreplace(nsb, i, i + find.length(), replacewith).toString();
				
			}
			i++;
		}
		return sb.toString();
	}
	
	/** Because the string buffer replace method does not exist in 1.1 (which
	  * most browsers support, I have had to implement my own version of it). */
	public static StringBuffer stringbuffreplace(StringBuffer sb, int start, int end, String replacewith) {
	
		String thebuff = sb.toString(); // convert buff to string
		String firstchunk = thebuff.substring(0, start); // get left side before replace
		String secondchunk = thebuff.substring(end, sb.length()); // get right side after replace
		String output = firstchunk + replacewith + secondchunk; // build new string
		sb = new StringBuffer(output); // return it
		return sb;
		
	}
	
	/*** Finds < in strings and throws away everything upto and including the >
	   */
	public static String removehtml(String s) {
		
		int i = 0;
		boolean oktoadd = true;
		String output = "";
		
		while (i <= s.length() - 1) {
		
			if (s.substring(i, i + 1).equals("<")) {
				oktoadd = false;
			}
			if (s.substring(i, i + 1).equals(">")) {
				i++;
				oktoadd = true;
			}
			if (oktoadd && i <= s.length() - 1)
				output = output + s.substring(i, i + 1);
				
			i++;				
		}
		
		return output;
		
	}
  
  
}