package iageinteractive;

/**
 * Generic collection class used to hold groups of objects.
 * All methods are synchronized to attempt to gain some semblance
 * of thread safety.
 */
public class iagecollection {

  // Useful class to inherit from - imitates MS collection classes
  // in Java - much nicer to use than poxy Java arrays.
  // (even if I did write it myself!)

  private Object[] obs = new Object[0];
  private int numincollection = 0;

  /** Add an object to the collection */
  public synchronized int add(Object o) {
    // Adds the specified object to the collection
    if (numincollection == 0) {
      obs = new Object[2];
      obs[1] = o;
      numincollection = 1;
      return 1;
    }
    else
    {
      numincollection = numincollection + 1;
      // Create a new array with one more bound than the previous
      Object[] ob2 = new Object[numincollection + 1];
      // Add in all references from the main array
      int i = 0;
      while (i < numincollection) {
        ob2[i] = obs[i];
        i++;
      }
      // Add our new object
      ob2[i] = o;
      // Assign the new array to the old array
      obs = ob2;
      // return
      return i;
    }
  }

  /** Retrieve an object. Note that whatever you get out will be
    * a standard java.lang.Object type object - you must cast it
    * to the real thing - eg. location l = (location)olocations.get(1);
    */
  public synchronized Object get(int index) {
    // Returns the object with that index
    return obs[index];
  }

  /*** Sets the indexed item to be a new object */
  public synchronized void set(int index, Object obj) {
  	obs[index] = obj;
  }

  /** Removes an object from the collection */
  public synchronized void remove(int index) {
    // Removes the object with that index and re-orders
    int i = index;
    while (i < numincollection) {
      obs[i] = obs[i + 1];
      i++;
    }
    numincollection--;
  }

  /** Returns the number of items in the collection */
  public synchronized int getCount() {
    return numincollection;
  }

}