package iagecompiler;

public class syntaxchecker {

	int pc = 0;
	int ins = 0;
	iagecode codeline = null;
	String curins = "";
	iagecode localvars = new iagecode();

	/** Runs through the code and tests the syntax */
	public void docheck(iagecode ic) throws Exception {
		
		pc = 1;
		ins = 1;
		String ccline = "";
		
		while (pc <= ic.getCount()) {
			ccline = ic.get(pc).trim();
			if (ccline != "") {
				codeline = splitstring(ccline, " ");
				ins = 1;
				while (ins <= codeline.getCount()) {
					curins = codeline.get(ins);
					codetester();
					ins++;
				}
			}
			pc++;
		}
	}
	
	public void codetester() throws Exception {
		
		if (curins.startsWith("'")) {skipline(); return;} // Comments
		if (curins.trim().equals("")) {skipline(); return;} // Second blank line check
		if (curins.equalsIgnoreCase("ask")) {Cmd_Ask(); return;}
		if (curins.equalsIgnoreCase("cancelevent")) {skipline(); return;}
		if (curins.equalsIgnoreCase("end")) {skipline(); return;}
		if (curins.equalsIgnoreCase("goto")) {Cmd_Goto(); skipline(); return;}
		if (curins.equalsIgnoreCase("call")) {Cmd_Call(); skipline(); return;}
		if (curins.equalsIgnoreCase("proc")) {skipline(); skipline(); return;}
		if (curins.equalsIgnoreCase("if")) {Cmd_If(); skipline(); return;}
		if (curins.startsWith(";")) {Cmd_IfVerb(); skipline(); return;}
		if (curins.startsWith("#")) {Cmd_IfAdverb(); skipline(); return;}
		if (curins.equalsIgnoreCase("while")) {Cmd_While(); skipline(); return;}
		if (curins.equalsIgnoreCase("endwhile")) {skipline(); skipline(); return;}
		if (curins.equalsIgnoreCase("else")) {skipline(); skipline(); return;}
		if (curins.equalsIgnoreCase("endif")) {skipline(); skipline(); return;}
		if (curins.equalsIgnoreCase("var")) {Cmd_Var(); skipline(); return;}
		if (checkcommand("array.")) {Obj_Array(); skipline(); return;}
		if (curins.equalsIgnoreCase("showpicture")) {Cmd_ShowPicture(); skipline(); return;}
		if (curins.equalsIgnoreCase("printallin")) {Cmd_PrintAllIn(); skipline(); return;}
		if (curins.equalsIgnoreCase("printallinexcept")) {Cmd_PrintAllInExcept(); skipline(); return;}
		if (curins.equalsIgnoreCase("printallexcept")) {Cmd_PrintAllExcept(); skipline(); return;}
		if (curins.equalsIgnoreCase("outputcontentsof")) {Cmd_OutputContentsOf(); skipline(); return;}
		if (curins.equalsIgnoreCase("addverb")) {Cmd_AddVerb(); skipline(); return;}
		if (curins.equalsIgnoreCase("addnoun")) {Cmd_AddNoun(); skipline(); return;}
		if (curins.equalsIgnoreCase("addadverb")) {Cmd_AddAdverb(); skipline(); return;}
		if (curins.equalsIgnoreCase("addlocation")) {Cmd_AddLocation(); skipline(); return;}
		if (curins.equalsIgnoreCase("additem")) {Cmd_AddItem(); skipline(); return;}
		if (curins.equalsIgnoreCase("addnpc")) {Cmd_AddNPC(); skipline(); return;}
		if (curins.equalsIgnoreCase("removeitem")) {Cmd_RemoveItem();skipline(); return;}
		if (curins.equalsIgnoreCase("removenpc")) {Cmd_RemoveNPC(); skipline(); return;}
		if (curins.equalsIgnoreCase("removelocation")) {Cmd_RemoveLocation(); skipline(); return;}
		if (curins.equalsIgnoreCase("returnvalue")) {Cmd_ReturnValue(); skipline(); return;}
		if (checkcommand("character(")) {Obj_Character(); skipline(); return;}
		if (checkcommand("item(")) {Obj_Item(); skipline(); return;}
		if (checkcommand("location(")) {Obj_Location(); skipline(); return;}
		if (checkcommand("currentplayer.")) {Obj_CurrentPlayer(); skipline(); return;}
		if (checkcommand("player(")) {Obj_Player(); skipline(); return;}
		if (checkcommand("playerarray(")) {Obj_PlayerArray(); skipline(); return;}
		if (checkcommand("flag(")) {Obj_Flag(); skipline(); return;}
		if (checkcommand("game.")) {Obj_Game(); skipline(); return;}
		if (checkcommand("input.")) {Obj_Input(); skipline(); return;}
		if (checkcommand("internal.")) {Obj_Internal(); skipline(); return;}
		if (checkcommand("message(")) {Obj_Message(); skipline(); return;}
		
		// See if it equates to a variable
		int i = 1;
		boolean foundvar = false;
		while (i <= localvars.getCount()) {
			if (localvars.get(i).equalsIgnoreCase(curins)) {
				foundvar = true;
				skipline();
				break;
			}
			i++;
		}
		if (!foundvar) {
			// It isn't a variable and it isn't a command - fail
			throw new Exception("Unable to resolve instruction: " + curins);
		}
	}
	
	private String getnextinstruction() {
		ins++;
		curins = codeline.get(ins);
		return new String(curins);
	}
	
	private void skipline() {
		ins = codeline.getCount() + 1;
		return;
	}
	
	private boolean checkcommand(String ccheck) {
		String tester = curins.toLowerCase();
		if (tester.startsWith(ccheck.toLowerCase()))
			return true;
		else
			return false;
	}
	
	/*** Splits a string and returns an iagecode collection */
	private iagecode splitstring(String tosplit, String delimiter) {
	
		// Break by spaces and fill vwords
		int i = 0;
		int spos = 0;
		iagecode vwords = new iagecode();
		
		i = tosplit.indexOf(delimiter);
		while (i != -1) {
			
			// Add the word
			vwords.add(tosplit.substring(spos, i));
			spos = i + 1;
			i = tosplit.indexOf(delimiter, spos);
			
		}
		
		// Add the final word
		vwords.add(tosplit.substring(spos, tosplit.length()));
		
		// Return them
		return vwords;
		
	}
	
	/*** Checks to see if a variable name is valid */
	private boolean isvalidvariable(String varname) {
		
		if (varname.startsWith("if")) {return false;}
		if (varname.startsWith("goto")) {return false;}
		if (varname.startsWith("call")) {return false;}
		if (varname.startsWith("while")) {return false;}
		if (varname.startsWith("for")) {return false;}
		if (varname.startsWith("var")) {return false;}
		if (varname.startsWith("ask")) {return false;}
		if (varname.startsWith("getitemfromnoun")) {return false;}
		if (varname.startsWith("outputcontentsof")) {return false;}
		if (varname.startsWith("printallexcept")) {return false;}
		if (varname.startsWith("printallin")) {return false;}
		if (varname.startsWith("addverb")) {return false;}
		if (varname.startsWith("addadverb")) {return false;}
		if (varname.startsWith("addnoun")) {return false;}
		if (varname.startsWith("additem")) {return false;}
		if (varname.startsWith("addlocation")) {return false;}
		if (varname.startsWith("addnpc")) {return false;}
		if (varname.startsWith("removeitem")) {return false;}
		if (varname.startsWith("removelocation")) {return false;}
		if (varname.startsWith("removenpc")) {return false;}
		if (varname.startsWith("playsound")) {return false;}
		if (varname.startsWith("showpicture")) {return false;}
		if (varname.startsWith("openurl")) {return false;}
		if (varname.startsWith("stopmidi")) {return false;}
		if (varname.startsWith("playmidi")) {return false;}
		if (varname.startsWith("playmovie")) {return false;}
		if (varname.startsWith("if")) {return false;}
		if (varname.startsWith("end")) {return false;}
		if (varname.startsWith("cancelevent")) {return false;}
		if (varname.startsWith("endwhile")) {return false;}
		if (varname.startsWith("endif")) {return false;}
		if (varname.indexOf(";") != -1) {return false;}
		if (varname.indexOf("#") != -1) {return false;}
		if (varname.indexOf(":") != -1) {return false;}
		if (varname.indexOf("!") != -1) {return false;}
		if (varname.indexOf("\"") != -1) {return false;}
		if (varname.indexOf("~") != -1) {return false;}
		if (varname.indexOf("&") != -1) {return false;}
		if (varname.indexOf("+") != -1) {return false;}
		if (varname.indexOf("-") != -1) {return false;}
		if (varname.indexOf("^") != -1) {return false;}
		if (varname.indexOf("*") != -1) {return false;}
		if (varname.indexOf("/") != -1) {return false;}
		if (varname.indexOf("\\") != -1) {return false;}
		if (varname.indexOf("(") != -1) {return false;}
		if (varname.indexOf(")") != -1) {return false;}
		if (varname.indexOf("[") != -1) {return false;}
		if (varname.indexOf("]") != -1) {return false;}
		if (varname.indexOf("{") != -1) {return false;}
		if (varname.indexOf("}") != -1) {return false;}
		
		// If we managed to get here - it must be ok
		return true;
	}
	
	private String Cmd_Ask() throws Exception {return "";}
	private void Cmd_Goto() throws Exception {}
	private void Cmd_Call() throws Exception {}
	private void Cmd_If() throws Exception {}
	private void Cmd_IfVerb() throws Exception {}
	private void Cmd_IfAdverb() throws Exception {}
	private void Cmd_While() throws Exception {}
	
	private void Cmd_Var() throws Exception {
		String vname = getnextinstruction();
		if (!isvalidvariable(vname)) {
			throw new Exception("Invalid variable name - '" + vname + "'");
		}
		// Add it to our list of variables:
		localvars.add(vname);
	}
	
	
	private String Obj_Array() throws Exception {return "";}
	private void Cmd_ShowPicture() throws Exception {}
	private void Cmd_PrintAllIn() throws Exception {}
	private void Cmd_PrintAllInExcept() throws Exception {}
	private void Cmd_PrintAllExcept() throws Exception {}
	private void Cmd_OutputContentsOf() throws Exception {}
	private void Cmd_AddVerb() throws Exception {}
	private void Cmd_AddNoun() throws Exception {}
	private void Cmd_AddAdverb() throws Exception {}
	private void Cmd_AddLocation() throws Exception {}
	private void Cmd_AddItem() throws Exception {}
	private void Cmd_AddNPC() throws Exception {}
	private void Cmd_RemoveItem() throws Exception {}
	private void Cmd_RemoveNPC() throws Exception {}
	private void Cmd_RemoveLocation() throws Exception {}
	private void Cmd_ReturnValue() throws Exception {}
	private String Obj_Character() throws Exception {return "";}
	private String Obj_Item() throws Exception {return "";}
	private String Obj_Location() throws Exception {return "";}
	private String Obj_CurrentPlayer() throws Exception {return "";}
	private String Obj_Player() throws Exception {return "";}
	private String Obj_PlayerArray() throws Exception {return "";}
	private String Obj_Flag() throws Exception {return "";}
	private String Obj_Game() throws Exception {return "";}
	private String Obj_Input() throws Exception {return "";}
	private String Obj_Internal() throws Exception {return "";}
	private String Obj_Message() throws Exception {return "";}
		
}
