
import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;

public class iageconnector {

	// Private members
	private String Version = "<b>IAGE Client Applet Version 020709</b>";
	private String CopyrightMessage = "<br>Copyright(c)2001-2002, R.Rawson-Tetley";
	private Socket Con;
	private DataInputStream in;
	private PrintWriter out;
	private PreOutput console;
	private Label location;
	private Label score;
	private listenthread lp;
	private boolean isconnected = false;
	
	public iageconnector (PreOutput ConsoleReference, 
						  Label LocationReference, 
						  Label ScoreReference,  
						  String IPAddress, 
						  String salias) {

	    console = ConsoleReference;
	    location = LocationReference;
	    score = ScoreReference;
	
	    // Attempt to connect to the IP specified
	    try {
			// Clear console ready for output
			OutputText(CopyrightMessage);
			
			// Parse the IP address - if there is a :xxxx on the
			// end, connect on that port, otherwise assume the
			// default of 1111
			int sep = IPAddress.indexOf(":");
			int port = 1111;
			
			if (sep != -1) {
				port = Integer.parseInt(IPAddress.substring(sep + 1, IPAddress.length()));
				IPAddress = IPAddress.substring(0, sep);
			}
			
			Con = new Socket(IPAddress, port);
			out = new PrintWriter(Con.getOutputStream(), true);
			in = new DataInputStream(Con.getInputStream());
			isconnected = true;
	    }
		catch(Exception e) {
			OutputText("<br>Error attempting connection to " + IPAddress + ": " + e.getMessage());
			e.printStackTrace();
			return;
	    }
	    
	    // Inform of successful connect
	    OutputText("<br>Successfully connected to " + IPAddress);
	
	    // Start our listen process
	    lp = new listenthread(Con, in, out, this);
	
	    // Transmit startup request code
	    Send("setalias " + salias + ".run_on_start", true);
	}

	/** Output to screen */
	public void OutputText(String s) {
		console.Output(s);
	}
  
	/** Look for special strings, process them and output them */
	public void PreProcessAndOutput(String s) {
	
		String rs = s; // Latest version of string
		int start;
		int end;
		String firstpart;
		String secondpart;
		String paramvalue;
		String curfindstring;
		boolean hastitle = false;
		String titletext = "";
		final int seplen = 1; // Length of special command separator - at present |<br>
		
	
		// SETSCREEN
		curfindstring = "SETSCREEN: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Manipulate screen
                        
			
			
			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;
			
		}
		
		// TITLE
		curfindstring = "TITLE: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Set the title
			location.setText(paramvalue);
			
			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length());
			rs = firstpart + secondpart;
			
			hastitle = true;
			titletext = secondpart;
		}
				
		// IMAGE
		curfindstring = "IMAGE: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			
			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length());
			rs = firstpart + secondpart;
			
		}
		
		
		// MIDI
		curfindstring = "MIDI: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Play MIDI
			try {

				URL img = new URL(paramvalue);

				// Play the tune
                //AudioClip mc = Applet.getAudioClip(img);
                //mc.play();

			}
			catch(MalformedURLException e) {
				OutputText("Bad URL: " + e.getMessage());
			}
            catch(IOException e) {
                    OutputText("Could not use MIDI: " + paramvalue);
            }


			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;

		}

		// MOVIE
		curfindstring = "MOVIE: ";
		if (rs.indexOf(curfindstring) > 0) {

			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);

			// Play Movie


			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;
			
		}
		
		
		// SOUND
		curfindstring = "SOUND: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Play sound
			try {

				URL img = new URL(paramvalue);

				// Play the tune
                //AudioClip so = Applet.getAudioClip(img);
                //so.play();

			}
			catch(MalformedURLException e) {
				OutputText("Bad URL: " + e.getMessage());
			}
            catch(IOException e) {
                OutputText("Could not use sound: " + paramvalue);
            }

			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;
			
		}
		
		// URL
		curfindstring = "URL: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Open browser with URL
			
			
			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;
			
		}
		
		// SCORE
		curfindstring = "SCORE: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Set the score
			score.setText(paramvalue);
			
			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;
			
		}
		
		// QUIT THE CLIENT
		curfindstring = "QUIT: DIE";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Kill everything
			this.Kill();
			
			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;
			
		}
	
		// If there's anything left, output it
		if (rs.length() > 4) {
			OutputText(rs);
		}
	}
	
	/** Close connection from server */
	public void Kill() {
		// Tell the server this player quit
		Send("quit", true);
		// Tell the listening thread that it's work is done
		lp.isFinished = true;
		isconnected = false;
		// Clear our socket references to be picked up
		// for garbage collection
		out = null;
		in = null;
		Con = null;
		// Kill renderer
		console.stopThread();
		

	}

	/** Transmit text down the pipe and echo to screen */
	public void Send(String s, boolean BeQuiet) {

		if (!isconnected) return;
		
		// Display on screen
		if (!BeQuiet) {OutputText("<br>--> " + s);}
		out.write(s + ".getscore");
		out.flush();
	}

}
