/* DisplayObjectTree */

char *tree_caption;

int DisplayObjectTree(char *caption)
{
	tree_caption = caption;
	
	DialogBox(AppInstance, MAKEINTRESOURCE(HD_OBJECTTREE), 
		wndDebug, TreeDialog);
}


BOOL CALLBACK TreeDialog(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			int i;
			HTREEITEM *tree;
			TV_ITEM tvi;
			TV_INSERTSTRUCT tvis;

			SetWindowText(hwndDlg, tree_caption);
			SetFocus(GetDlgItem(hwndDlg, HD_TREEVIEW));

			tree = malloc((size_t)objects*sizeof(HTREEITEM));
			if (tree==NULL) DebuggerFatal(D_MEMORY_ERROR);

			for (i=0; i<objects; i++)
			{
				tvi.pszText = objectname[i];
				tvi.hItem = (HTREEITEM)i;
				tvi.mask = TVIF_TEXT | TVIF_CHILDREN;
				tvi.cChildren = 1;
				tvis.hInsertAfter = TVI_LAST;
				tvis.item = tvi;

				tvi.pszText = objectname[i];
				tvi.hItem = tree[i];
				if (i==0)
					tvis.hParent = TVI_ROOT;
				else
					tvis.hParent = tree[Parent(i)];
				tvis.item = tvi;
				if (i==0)
					tvis.hInsertAfter = TVI_FIRST;
				else if (Elder(i))
					tvis.hInsertAfter = tree[Elder(i)];
				else
					tvis.hInsertAfter = tree[Parent(i)];

				SendMessage(GetDlgItem(hwndDlg, HD_TREEVIEW),
					TVM_INSERTITEM, 0, (LPARAM)&tvis);
			}

			return 0;       /* since focus has been set */
		}

		case WM_COMMAND:
			switch LOWORD(wParam)
			{
				case IDOK:
//					EndDialog(hwndDlg, 1);
					break;

				case IDCANCEL:
					event.action = CANCEL;
					EndDialog(hwndDlg, 0);
					break;
			}
			return 0;
	}

	return 0;
}


