/*
	PalmHugo.h
*/

#ifdef OLD_PALMOS_31
#include <Pilot.h>
#else
#include <PalmOS.h>
#endif

#define PH_CREATOR_TYPE	 'HUGO' // application
#define PH_GAME_TYPE	 'Hugo' // game files
#define PH_SAVE_TYPE	 'HugS' // save files
#define PH_SCRIPT_TYPE	 'HugT' // transcripts
#define PH_RECORD_TYPE	 'HugR' // recorded commands
#define PH_PREFS_TYPE	 'HugP' // preferences/setup
#define PH_INTERNAL_TYPE 'HugI' // internal resume data

#define CURRENT_GAME_DATA  "Hugo current dynamic data"
#define CURRENT_GAME_SNAP  "Hugo current snapshot"

#define MAX_FILELIST		32

enum PH_ERROR_TYPE
{
	PH_NO_ERROR = 0,
	PH_NO_SELECTION,
	PH_NO_FILES
};

#define PH_BOTTOM_ROW 11

#define SCROLLBACK_SIZE 3000
extern char scrollback_buffer[];
extern int scrollback_pos;

#define NUM_DIRECTIONS 12
#define DIRECTION_LENGTH 12
#define DIRBUTTON_LENGTH  2
typedef struct
{
	char cmd[DIRECTION_LENGTH+1];
	char button[DIRBUTTON_LENGTH+1];
} dir_list_struct;

#define WORD_BUTTON 2000	// id
#define DIRBUTTON_TOP_ROW 150
#define DIRBUTTON_HEIGHT   9

#define NUM_COMMANDS 12
#define COMMAND_LENGTH 24
typedef struct
{
	char cmd[COMMAND_LENGTH+1];
	Boolean linefeed;
} command_list_struct;

#define NUM_WORDS    12
#define WORD_LENGTH  24
typedef struct
{
	char word[WORD_LENGTH+1];
	Boolean linefeed;
} word_list_struct;

typedef struct 
{
	Boolean no_blank_lines;
	Boolean minimal_windows;
	Boolean use_colors;
	Boolean smartformatting;
	dir_list_struct dir_list[NUM_DIRECTIONS];
	command_list_struct command_list[NUM_COMMANDS];
	word_list_struct word_list[NUM_WORDS];
} PalmHugoPreferenceType;

extern PalmHugoPreferenceType ph_prefs;


/* PalmHugo.c */
void ShowPleaseWait(Boolean show);
void SetWindowColors(void);
void RestoreWindowColors(void);
void SetDefaultFormColors(void);
void SetGameFormColors(void);
void *GetObjectPtr(UInt16 objectID);
void FreeGameData(void);
void RestoreWindow(void);
void ProcessPalmOSEvents(void);
void ProcessPendingPalmOSEvents(void);
Boolean RunDialog(UInt16 formID);

extern UInt32 romVersion;
extern RGBColorType field_text, field_back, field_caret,
	default_field_text, default_field_back, default_field_caret;
extern Boolean got_first_input;
extern Boolean auto_resuming;
extern Boolean promptmore_waiting;
extern Int16 palm_screen_width;
extern Int16 palm_screen_height;
extern int palm_display_depth;
extern int processed_shortcut;
extern Boolean override_window_save;
extern Boolean override_window_restore;

void PopupMessage(char *title, char *msg);
extern char ph_debug;


// For File forms
extern char file_selected[];
extern UInt32 file_select_type;
extern int file_select_error;


/* hepalm.c */
void PushKeypress(int c);
int PullKeypress(void);

extern int current_text_color, current_back_color;
extern int current_input_font;
extern Boolean getline_active;
extern int getline_x, getline_y;
