!----------------------------------------------------------------------------
!
!     Grammar for Verb Stub Routines v2.2.1 by Kent Tessman (c) 1995-1996
!                      for use with Hugo Compiler v2.2
!
!----------------------------------------------------------------------------
!
! This grammar file must be included along with the standard grammar file
! at the start of the game file (before any executable code); GRAMMAR.G 
! does this if the VERBSTUBS flag is set.
!
!----------------------------------------------------------------------------

#version 2.2

xverb "yes"
	*                                       DoYes

xverb "no"
	*                                       DoNo

xverb "sorry"
	*                                       DoSorry

verb "use"      
	* object                                DoUse

verb "smell", "sniff", "inhale", "breathe"
	*                                       DoSmell
	* object                                DoSmell

verb "jump", "leap", "hop"
	*                                       DoJump

verb "wave"
	*                                       DoWaveHands
	* "hands"                               DoWaveHands
	* "to" object                           DoWaveHands
	* held                                  DoWave

verb "throw", "hurl", "toss"
	*                                       DoVague
	* held                                  DoThrowAt
	* held "at" xobject                     DoThrowAt

verb "climb"
	*                                       DoClimb
	* "in"/"into"/"inside" object           DoEnter
	* "in"/"inside"                         DoEnter
	* "on"/"onto" object                    DoEnter
	* "off"/"offof" object                  DoExit
	* "down"/"out"/"outside"                DoExit
	* "up"/"down" object                    DoClimb
	* object                                DoClimb

verb "sleep", "rest", "nap", "snooze"
	*                                       DoSleep

verb "push", "shove"
	*                                       DoVague
	* "on" object                           DoPush
	* object                                DoPush

verb "pull", "yank", "tug"
	*                                       DoVague
	* "on" object                           DoPull
	* object                                DoPull

verb "kiss", "hug"
	*                                       DoVague
	* object                                DoKiss

verb "swim", "dive"
	*                                       DoSwim

verb "wake", "awake", "awaken"
	*                                       DoWake
	* "up"                                  DoWake
	* "up" living                           DoWakeCharacter
	* living                                DoWakeCharacter

verb "touch", "feel"
	*                                       DoVague
	* object                                DoTouch

verb "tie", "attach", "fasten", "lash"
	*                                       DoVague
	* object                                DoTie
	* object "to" xobject                   DoTie
	* object "with" held                    DoTie

verb "untie", "detach", "unfasten", "unlash"
	*                                       DoVague
	* object                                DoUntie
	* object "from" xobject                 DoUntie

verb "burn", "light", "incinerate"
	*                                       DoVague
	* object                                DoBurn
	* object "with" held                    DoBurn

verb "set"
	* "fire" "to" object                    DoBurn
	* object "on" "fire"                    DoBurn
	* object "ablaze"                       DoBurn

verb "cut", "slice", "chop", "sever"
	*                                       DoVague
	* object                                DoCut
	* object "with" held                    DoCut

verb "dig", "burrow"
	*                                       DoVague
	* "in"/"into" object                    DoDig
	* "in"/"into" object "with" held        DoDig
	* object                                DoDig
	* object "with" held                    DoDig

verb "yell", "shout", "scream", "bellow", "cry"
	*                                       DoYell

verb "search"
	*                                       DoVague
	* "for" object                          DoVague
	* "in" object                           DoSearch
	* object                                DoSearch

xverb "help"                                    
	*                                       DoHelp
	* object                                DoHelpChar

