!--------------------------------------------------!
!                                                  !
! ZORKDIAG.H  - The DIAGNOSE command and           !
!               player damage                      !
!                                                  !
! Library file by Joe Merical (python_q@email.com) !
! Last modified: 6/28/02                           !
!                                                  !
! See Zork.html for more information               !
!                                                  !
!--------------------------------------------------!


System_file;

! TOTAL_ENERGY set to 100, by default
Default TOTAL_ENERGY 100;


! Damage variables

! current total damage on the player
Global cur_damage = 0;

! default message when player is killed by damage
Global default_damage = "It appears that that last blow was too much for you.
	I'm afraid you are dead.";

! the last object to call CauseDamage()
Global last_damage;


! The DIAGNOSE verb

Verb "diagnose" "diag" * -> Diagnose;

[ DiagnoseSub;
if (cur_damage == 0) "You are in perfect health.^You can be killed by
	a serious wound.";
else {
	if (cur_damage < (TOTAL_ENERGY/2)) "You have a light wound, which will be cured
		after ", cur_damage, " moves.^You can be killed by a serious wound.";
	if (cur_damage >= (TOTAL_ENERGY/2)) "You have a serious wound, which will be
		cured after ", cur_damage, " moves.^You can be killed by one more light wound.";
}
];


! CauseDamage(DAMAGE);
! Inflicts damage on the player;

[ CauseDamage damage;
	StartDaemon(d_o);
	cur_damage = cur_damage + damage;
	last_damage = self;
	rfalse;
];


! CheckDamage();
! Run by TimePasses to see if the player is still alive

[ CheckDamage;
		if (TOTAL_ENERGY <= cur_damage) {
			print "^";
			if (last_damage provides damage_death) print (string) last_damage.damage_death;
			else print (string) default_damage;
			deadflag = 1;
		}
];


! Damage Object (d_o)
! Heals the player one damage point per turn

Object d_o 
	with damage_death,
	daemon [; if ((cur_damage < TOTAL_ENERGY)&&(cur_damage > 0)) cur_damage--; ];


! TimePasses
! Runs the CheckDamage() function
! To use your own TimePasses() routine:
! Replace TimePasses before including any files
! and write a new TimePasses routine
! Be sure to run CheckDamage() within TimePasses

[ TimePasses; CheckDamage(); ];