/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import org.zmpp.io.OutputStream;
import org.zmpp.swingui.Viewport;
import org.zmpp.vm.Machine;

public class ScreenOutputStream
implements OutputStream {
    private boolean isSelected;
    private StringBuilder streambuffer;
    private Machine machine;
    private Viewport viewport;

    public ScreenOutputStream(Machine machine, Viewport viewport) {
        this.machine = machine;
        this.viewport = viewport;
        this.streambuffer = new StringBuilder();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void select(boolean bl) {
        this.isSelected = bl;
    }

    public void print(short s, boolean bl) {
        if (s == 13) {
            this.printChar('\n', bl);
        } else {
            this.printChar(this.machine.getGameData().getZsciiEncoding().getUnicodeChar(s), bl);
        }
    }

    public void deletePrevious(short s) {
        char c = this.machine.getGameData().getZsciiEncoding().getUnicodeChar(s);
        this.viewport.getCurrentWindow().backspace(c);
    }

    public void flush() {
        if (this.streambuffer.length() > 0) {
            this.viewport.getCurrentWindow().printString(this.streambuffer.toString());
            this.streambuffer = new StringBuilder();
        }
    }

    public void close() {
    }

    private void printChar(char c, boolean bl) {
        if (bl || !this.viewport.getCurrentWindow().isBuffered()) {
            this.viewport.getCurrentWindow().printString(String.valueOf(c));
        } else {
            this.streambuffer.append(c);
        }
    }
}

