! Custom routines. These are routines that can be provided by the programmer to do certain
! things. Unless you have a VERY good reason, NEVER allow a routine that replaces a stubbed one
! to contain nothing. It MUST contain a rfalse!

! AfterLife
! Allows the player to be given a second chance before death.
! Only called if deadflag is not 0 (normal) or 2 (winning).
! i.e. 1 (death) or 3 and above (exotic death).
[ AfterLife;
 rfalse;
];

! AfterPrompt
! Just after the prompt is displayed.
! Whereas GamePostRoutine is like a super-after rule, AfterPrompt should be used for system
! manipulation (as opposed to game manipulation).
[ AfterPrompt;
 rfalse;
];

! Amusing
! Providing the AMUSING_PROVIDED default is set to 0, shows amusing things to do.
! So long as you die (method 2, i.e. winning).
[ Amusing;
 rfalse;
];

! BeforeParsing
! Just before the prompt is displayed.
! Whereas GamePreRoutine is like a super-before rule, BeforeParsing should be used for system
! manipulation (as opposed to game manipulation).
[ BeforeParsing;
 rfalse;
];

! DarkToDark
! To quote Graham Nelson:
! "Called when a player goes from one dark room into another one; a splendid excuse to kill the
!  player off."
[ DarkToDark;
 rfalse;
];

! DeathMessage
! What to do in the likely event of death.
! Use of deadflag (the variable which controls your death):
! 0 - Normal (playing).
! 1 - Dead (standard message).
! 2 - Won (standard message).
! 3 and above - Custom messages.
! Setting this variable to any non-zero value will end the game.
! Despite the name, 'deadflag' can (and must) also refer to winning and losing.
[ DeathMessage;
 switch (deadflag)
 {
  4: print "[Roll credits]";	! As do most programs when they end.
  default: ;			! Do nothing.
 }
 rfalse;
];

! GamePostRoutine
! Allows you to do things after the player has done something.
[ GamePostRoutine;
 rfalse;
];

! GamePreRoutine
! Allows you to do things before the player can do anything.
[ GamePreRoutine;
 rfalse;
];

! TimePasses
! What happens with the passing of time. This is called after every turn.
[ TimePasses;
 rfalse;
];

! PrintRank
! Displays a rank based on your current score.
[ PrintRank;
 print ". ";	! As typing 'score' both displays your score and rank.
 switch (score)
 {
  default: ;	! Do nothing by default.
 }
 NewLine (1);	! As typing 'score' both displays your score and rank.
 rfalse;
];

! ParserError
! Prints an error message dependent upon what you tell it.
[ ParserError TheError;
 switch (TheError)
 {
  default:
   ! THIS MUST BE LAST!
   rfalse;	! Carry on, print whatever you were going to print.
 }
 rfalse;	! Should NEVER get here! Use "xxx" or print_ret "xxx", NEVER just print "xxx".
];

[PrintTaskName ach;
 switch (ach)
 {
 }
];

! PressAKey
! Waits for a key to be pressed.
[ PressAKey pkey;
 if (pkey~=0)	! Option to display a prompt.
 {
  NewLine (1);
  print "[Please press a key to continue]";
 }
 @read_char 1 0 0 pkey;
 return pkey;	! So PressAKey can have many uses.
];

! NewLine
! Prints 'NewLines' number of new_lines.
[ NewLine NewLines Count;
 for (Count=0: Count<NewLines: Count++)
 {
  new_line;
 }
 rfalse;
];

! clrscr
! Clears the screen.
[ clrscr;
 @erase_window $ffff;
 rfalse;
];

! FormatText
! Syntax: FormatText (string);
! To quote Allen Garvin, the author of this routine:
! "I added the printf from the designer's manual, but didn't find it very useful, so I changed
! it into this :)"
! Note that this routine uses the global table 'printed_text'.
! You may need to increase $MAX_STATIC_DATA should you make this table larger.
[ FormatText format j k;
 @output_stream 3 printed_text;	! Most cunning. Re-route textual output to this array.
 print (string) format;		! Just print it out (to an array and not the screen).
 @output_stream -3;		! And resume normal service.
 j = printed_text-->0;		! Determine (less 2) the string length.
 for (k=2: k<j+2: k++)		! Then get to work.
 {
  if (printed_text->k == '%')	! A '%' symbol is used to control formatting.
  {
   switch (printed_text-> (++k))
   {
    '%': print "%";		! To get a % mark, use '%%'.
    ' ': spaces 1;		! To get a single space, '% '. Not sure why this may be of use.
    'B': style bold;		! i.e. use the sequence '%B' for bold text.
    'F': style fixed;		! i.e. use the sequence '%F' for fixed-point text.
    'P': style roman;		! i.e. use the sequence '%P' to return to normal.
    'R': style reverse;		! i.e. use the sequence '%R' for reverse-video text.
    'U': style underline;	! i.e. use the sequence '%U' for underlined text.
   }
  } else			! Just print the character out.
  {
   print (char) printed_text->k;
  }
 }
];

! What the Quip function does is to see if it has been called before with the same text. If so,
! it increments the appropriate member of the 'QuipsNumber' array. If not, it increases
! 'NoQuipsSeen' by 1, and stores the address of the text in the 'QuipsText' array, and puts 0
! in the corresponding place in the 'QuipsNumber' array.
! The robot names are printed with the proportional font turned off, so that the hanging indent
! will line up, and the function 'HangingIndent' is called to do that actual printing.
[ Quip
  n		! the number of times the quip should be ignored before printing
  ns		! the number of newlines at the start of the quip
  Character	! the character who says the quip
  text		! the packed address of the text of the quip
  ne		! the number of newlines at the end of the quip
  i		! the quip's index in the 'QuipsText' and 'QuipsNumber' arrays
  ;

 style roman;	! Just in case.
 ! If 'n' is -1, don't bother to store the quip because it can't possibly be seen twice.

 if (n == -1) jump QuipPrint;

 ! Have we seen this quip before? If so, increment the count of times seen, taking care not to
 ! overflow.

 for (i = 0: i < NoQuipsSeen: i++)
 {
  if (text == QuipsText-->i)
  {
   if (QuipsNumber->i < 255)
   {
    QuipsNumber->i = QuipsNumber->i + 1;
   }
   jump QuipFound;
  }
 }

 ! If we haven't seen it before, add it to the array

 if (NoQuipsSeen >= NUMBER_QUIPS)
 {
  "** Error: out of quip space **";
 }
 i = NoQuipsSeen;
 NoQuipsSeen ++;
 QuipsText-->i = text;
 QuipsNumber->i = 0;

 ! We only print the quip if the number of times it's been seen before matches the parameter
 ! 'n'.

 .QuipFound;
 if (QuipsNumber->i ~= n)
 {
  rfalse;
 }

 ! Now print it

 .QuipPrint;
 for (i = 0: i < ns: i++)
 {
  new_line;
 }
 font off;
 print (string)BotName-->(Character-1);
 font on;
 HangingIndent (text, BotLength->(Character-1));
 for (i = 0: i < ne: i++)
 {
  new_line;
 }
 style roman;
];

! Printing text with a hanging indent: Quip text is printed to an array in memory rather than
! to the screen (using the 'output_stream' opcode). Then for each line, a breakpoint is
! determined that prevents a word being split over the line. Then print the appropriate portion
! of the array (using the 'print_table' opcode), print the indent, and go back for another
! line. The indent is printed with the proportional font turned off.

Constant MAX_STRING_LENGTH 1000;	! maximum length of any quip in the game
Array sb -> MAX_STRING_LENGTH;		! buffer to hold the printed string

[ HangingIndent
  text		! packed address of text to print
  overlap	! extent to which first line sticks out over the 6-char indent
  len		! length of text in characters
  from		! first character not printed
  width		! width of screen in characters, less six character indent
  bp		! break point in string
  start		! where to start printing from
  n		! number of characters to print
  flag		! 0 if this is the first line being printed (so omit indent)
  ;

 ! String manipulation. The string starts out in encoded form, so it is first decoded to the
 ! string buffer:

 @output_stream 3 sb;
 print (string) text;
 @output_stream -3;

 ! Set up parameters (recall that the first two bytes of the array 'sb' hold the length).

 width = 0->33 - 6;
 len = sb-->0 + 2;
 from = 2;
 if (len > MAX_STRING_LENGTH)
 {
  "** Error: string was too long **";
 }

 while (from < len)
 {
  if (flag == 0)
  {
   flag = 1;
   bp = from + width - overlap;
  } else
  {
   font off;
   new_line;
   spaces 6 + overlap;
   font on;
   bp = from + width;
  }

  ! See if it can print the rest of the text on one line.

  if (bp >= len)
  {
   bp = len;
   jump FoundBreakPoint;
  }

  ! Find the best breakpoint, if any.

  for (: bp >= from: bp--)
  {
   if (sb->bp == ' ')
   {
    jump FoundBreakPoint;
   }
  }

  ! No breakpoint found, so split in the middle of the word.

  bp = from + width;

  ! Print the text from 'from' to the breakpoint.

  .FoundBreakPoint;
  start = sb + from;

  n = bp - from;
  @print_table start n 1;

  ! Skip any whitespace.

  from = bp;
  while (sb->from == ' ')
  {
   from ++;
  }
 }
];

! SoL
! To display SoL text.
[ SoL;
 print (NewLine)1, (FormatText)"[SATELLITE OF LOVE]", (NewLine)1;
 rfalse;
];

! Deep13
! As above, but for Deep 13.
[ Deep13;
 print (NewLine)1, (FormatText)"[DEEP 13]", (NewLine)1;
];

! MST3KLogo
! Displays the logo.
[ MST3KLogo;
 Center ("_________^");
 Center ("/           @@92^");
 Center ("/     Mystery   @@92^");
 Center ("|      Science    |^");
 Center ("|      Theater    |^");
 Center ("@@92      3000     /^");
 Center (" @@92___________/^^");
 rfalse;
];

! PushTheButtonFrank
! Simulates the effect of Frank pushing the button.
[ PushTheButtonFrank h i w;
 PressAKey (1);
 clrscr ();
 ! CODE TO PLAY THE BUTTON BEING PUSHED WILL GO HERE.
 font off;
 h = (0->32 - 3) / 2;
 w = (0->33 - 5) / 2;
 for (i = 0 : i < h - 1 : i++)
 {
  new_line;
 }
 spaces w; print "@@92 | /^";
 spaces w; print "--o--^";
 spaces w; print "/ | @@92";
 new_line;
 font on;
 PressAKey (0);
 clrscr ();
 NewLine (2);
];

! Introduction
! Displays the introductory text (the MST3K love theme and, optionally, the rest).
[ Introduction;
 style bold;
 print (Center)"MYSTERY SCIENCE THEATRE 3000, Adventure 102, Reel 1.", (NewLine)2;
 style roman;
 print "In a not too distant future, next Sunday A.D., there was a guy named Joel, not too different from you or me.", (NewLine)1;
 print "He worked at Gizmonic Institute, just another face in a red jumpsuit.", (NewLine)1;
 print "He did a good job cleaning up the place, but his bosses didn't like him so they shot him into space.", (NewLine)2;
 print "~We'll send him cheesy movies, the worst we can find.~ (La la la)", (NewLine)1;
 print "~He'll have to sit and watch them all, and we'll monitor his mind.~ (La la la)", (NewLine)1;
 print "Now keep in mind Joel can't control when the movies begin or end, (La la la)", (NewLine)1;
 print "because he used those special parts to make his robot friends.", (NewLine)2;
 print "Robot Roll Call:", (NewLine)1;
 print "Cambot (pan left)", (NewLine)1;
 Quip (-1, 0, Gypsy, "Hi, girl", 1);
 Quip (-1, 0, Tom, "What a cool guy", 1);
 Quip (-1, 0, Crow, "Wisecracker", 2);
 print (NewLine)1, "If you're wondering how he eats and breathes, and other science facts... (La la la)", (NewLine)1;
 print "Then repeat to yourself ~it's just a show, I should really just relax, for Mystery Science Theater 3000.~";
 NewLine (1);
 PressAKey (1);
 clrscr ();
 print "See rest of introduction? (Y/N) ";
 if (PressAKey (0)=='N' or 'n' or 27)	! No.
 {
  clrscr ();	! Clear the screen up.
  rfalse;	! Then return.
 }
 ! Everything from here on down is only displayed if the player wants to see it.
 clrscr ();
 MST3KLogo ();
 SoL ();
 print "[Crow and Tom are seated in front of a computer with the cover off. Gypsy looks on, and Joel is facing the camera]";
 Quip (-1, 2, Magic, "Thirty seconds to Commercial Sign.", 1);
 Quip (-1, 0, Joel, "Hi folks, and welcome to the Satellite of Love. I'm Joel Robinson, and these are my bots; Cambot, Gypsy, Tom Servo, and Crow T. Robot. Crow here has been trying to access his new Cosmoserve account, but he's hit a little snag. What's wrong Crow?", 1);
 Quip (-1, 0, Crow, "I don't know, Joel. I'm putting in a SCSI hard drive to store my downloads, but I just can't get it to read.", 1);
 Quip (-1, 0, Joel, "Well, let's see what we've got here. System setup set on autodetect. Cables all secure... Crow, what's this?! There's a big bullet hole right in the center of the drive!", 1);
 Quip (-1, 0, Crow, "Well jeez, Joel. The technician on the 24-hour hotline told me that SCSI devices needed to be terminated.", 1);
 Quip (-1, 0, Joel, "What?", 1);
 Quip (-1, 0, Crow, "It seemed like a good idea at the time...", 1);
 Quip (-1, 1, Magic, "Commercial Sign in 5, 4, 3, 2... Commercial Sign now.", 2);
 print "[Commercial Sign light begins flashing]";
 Quip (-1, 2, Joel, "We'll be right back, folks.", 2);
 print "[Important news about where to get a Barqtoo follows... Back on the SOL, Servo has a hunting rifle over his shoulder]";
 Quip (-1, 2, Tom, "Well, cheer up Crow. It could have been worse. You might have caught cold if he had told you to flash your BIOS.", 1);
 Quip (-1, 0, Crow, "Shut up Servo, and help me drain this sea moss out of the case.", 1);
 print "[The Mad Scientist's Light begins flashing]";
 Quip (-1, 1, Joel, "Cool it guys, Shaggy and Scooby are calling.", 1);
 Deep13 ();
 Quip (-1, 1, Forrester, "Greetings Joel, my little Ta-ra-ra-goon-dee-ay. My invention for this week is...", 1);
 SoL ();
 Quip (-1, 1, Joel, "It's just a TV set.", 1);
 Deep13 ();
 Quip (-1, 1, Forrester, "It may look like ~just a television set~, but it's actually something much more fiendish. You see, the first tenet of Mad Science states that world conquest can be facilitated by reducing the intelligence of the world's population. In the pre-electronic age, mad scientists had to work with infant children, who as you know acquire their intelligence by draining it out of the adults around them, reducing them to gibbering simpletons. Unfortunately, these effects are temporary, lasting only so long as the infant is actually present. However, the advent of artificial intelligence has provided a more lasting solution. Enter ~Dr. Forrester's Artificial Stupidity!~ To demonstrate, I have brought in the eminent Dr. Frankenheimer, of the University of Stuttgart.", 1);
 print "[TV's Frank walks onscreen in a suit and ridiculous looking false beard]";
 Quip (-1, 1, Frank, "[in Cheesy German accent] Guten Tag.", 1);
 Quip (-1, 0, Forrester, "Dr. Frankenheimer has degrees in Philosophy, Philology, and Metaphysico-theologico-cosmogony...", 1);
 Quip (-1, 0, Frank, "You find the metape between the triglyphs and the frieze section of the entabulature of classical Greek Doric temples.", 1);
 Quip (-1, 0, Forrester, "...and is generally regarded as being one of the three cleverest men in Europe.", 1);
 Quip (-1, 0, Frank, "All end terms distributed in the conclusion of a valid categorical syllogism must also be distributed in either the Major or Minor premises.", 1);
 Quip (-1, 0, Forrester, "His autobiography, ~Hello Professor~ has been #1 on the New York Times bestseller list for the last 18 years.", 1);
 Quip (-1, 0, Frank, "Capablanca could have avoided perpetual check and beaten Alekhine in the 27th game of the 1927 World Chess Championship by playing K-K2 rather than K-B2 on his final move.", 1);
 Quip (-1, 0, Forrester, "But just watch what happens to him after only a brief exposure to Artificial Stupidity. [Dr. F puts the set in front of Frank]", 1);
 Quip (-1, 0, Frank, "[normal voice] Oh, Baywatch!", 1);
 Quip (-1, 0, Forrester, "The unsuspecting rube innocently sits down, and becomes enticed by the pretty colours. The inane dialogue creeps into his synapses, the contrived plots work their way into his cerebral cortex, and before you know it...", 1);
 Quip (-1, 0, Frank, "[Frank (now in normal clothes and beardless) has begun drooling. His face has taken on a vacant stare]", 1);
 Quip (-1, 0, Forrester, "Well, the details are too disgusting even for me. But you get the idea. Oh Frank, how do you like the show?", 1);
 Quip (-1, 0, Frank, "What's ~show~?", 1);
 Quip (-1, 0, Forrester, "You know, the show on the set.", 1);
 Quip (-1, 0, Frank, "Duh, what's ~set~?", 1);
 Quip (-1, 0, Forrester, "Uh, back to you, Joel.", 1);
 SoL ();
 Quip (-1, 1, Joel, "Well sirs, when I was on Earth my two favourite hobbies were wargaming and golfing. Since I've been on the old Satellite of Love I don't get out much any more, so I've combined the two hobbies and produced ~Miniature Golf.~", 1);
 Deep13 ();
 Quip (-1, 1, Forrester, "Boobie, there's nothing new about Miniature Golf.", 1);
 SoL ();
 Quip (-1, 1, Joel, "Ah, but this is real Miniature Golf. You see, I've taken these Ral Partha lead miniatures from my old Dungeons & Dragons campaign, covered this tabletop with green felt, built up dunes from styrofoam blocks, and put together a Combat Results Table. I take my Character Sheet and these Lou Zocchi 10-sided dice and roll on the Drive Table. My character, Stud Greyfang, has a dexterity of 89, so I apply the proper die roll modifiers; -12 for the wind, +5 for a favourable sun angle, and -6 because my character had a heavy lunch at the clubhouse and would rather be taking a nap. Roll the percentile dice... 69! I got a 240 foot drive. So I use this protractor to mark my ball's position, roll again on the Ball Scatter Table, applying the modifiers for slope, damp ground, and ruts left by the greenskeeper's mower, resulting in a 12 foot North by Northwest roll, making my final position... here. Servo, your turn.", 1);
 Quip (-1, 0, Tom, "Okay, I roll the dice and get an... 86! Defender Liquified! Lose half of your combat factors and retreat the survivors three hexes.", 1);
 Quip (-1, 0, Joel, "Tom, that's not Miniature Golf. You're using the Combat Results Table from Panzergruppe Guderian!", 1);
 Quip (-1, 0, Crow, "I'll bet he sells more Nike's with his version than you do, Joel.", 1);
 Quip (-1, 0, Joel, "What do you think, sirs?", 1);
 Deep13 ();
 print (NewLine)1, "[Frank, still drooling, has begun chewing on a reel of film. Dr. Forrester tries unsuccessfully to wrestle it away from him]";
 Quip (-1, 2, Forrester, "FRANK, STOP THAT! You're eating today's movie! [Keeps trying to recover what's left of the film]. Your experiment today Joel is a stroke of luck for you. It was supposed to be Saturn 3, starring Kirk Douglas and Farrah Fawcett-Majors. But as a last minute substitution, we bring you a Deep 13 special. It's another Interactive Fiction acid trip; a pretentious little AGT suppository that we like to call ~A Fable.~ You are now at Witt's End. PAIN leads in all directions!", 1);
 print "[Dr. Forrester slams Frank's head into the Movie Sign button]";
 ! CODE GOES HERE TO PLAY THE BUTTON.
 NewLine (1);
 SoL ();
 print (NewLine)2, "[Movie Sign light is flashing]";
 Quip (-1, 1, Joel, "Oh, we've got movie sign!", 1);
 PressAKey (1);
 clrscr ();
 AGTIntro ();	! Display the game's original AGT introduction.
 rfalse;
];

! AGTIntro
! Displays the game's AGT introduction.
[ AGTIntro;
 print (Center)"* * * *  A    F A B L E  * * * *", (NewLine)1;
 print (Center)"by Stan Heller", (NewLine)1;
 print (Center)"Copyright  November, 1985   San Francisco, CA", (NewLine)2;
 print "Waves of sorrow rushed over him for reasons he could not easily explain. Max decided he needed a walk in the night air. He needed to think. He bundled himself up in his coat, scarf and hat. He looked in on his wife asleep in their bed. His infant son also slept peacefully in the crib at the bed's foot. He surveyed them quietly, as if for the last time and then he left the second floor apartment, closing the door quietly behind him.^";
 Quip (-1, 0, Tom, "Dr. Richard Kimble left his house on that fateful night...", 2);
 print "The fog was heavy. He could barely see the familiar neighborhood. It did not matter. Max had his thoughts. The thoughts were of himself, as always. He was thinking of all the people he had once been.^";
 Quip (-1, 0, Joel, "Who? Shirley MacLaine?", 1);
 Quip (-1, 0, Crow, "No, no, I bet he's in the Witness Protection Program.", 2);
 print "For some reason he felt like they had all left him behind this evening. Sitting in his house he felt like it was someone else who was there. He had been lost somewhere. Perhaps that is why on this particular evening he was out walking in the fog. He was looking for himself.", (NewLine)2, "Perhaps that is why he didn't notice as the sounds of the neighborhood faded quietly away. The pavement was not even pavement anymore.^";
 Quip (-1, 0, Joel, "When is a pavement not a pavement?", 1);
 Quip (-1, 0, Crow, "What is the sound of one hand clapping?", 2);
 print "Max was deep in reflection and never noticed he had wandered into someplace quite unusual.", (NewLine)2, "It occured to him after a while that he had been walking for quite some time. He scratched his head. He looked around for a familiar sign.^";
 Quip (-1, 0, Tom, "Ugh, buffalo tracks. Two...maybe three days old.", 2);
 print "~Lost in my own neighborhood,~ he muttered. ~Serves me right.~", (NewLine)2, "The fog streched out in all directions. He looked for street lamps, mildly surprised that there were none.", (NewLine)2, "~Where am I,~ he wondered.^";
 Quip (-1, 0, Joel, "He's fallen into Narnia!", 1);
 Quip (-1, 0, Tom, "Can't be. No lamp posts.", 2);
 PressAKey (1);
 clrscr ();
 rfalse;
];

! EndGame
! Displays the end game text.
[ End;
 clrscr ();
 ! CODE FOR PLAYING DOORS OUT WILL GO HERE.
 print "[1...2...3...4...5...6...G...]", (NewLine)2;
 SoL ();
 Quip (-1, 1, Tom, "Joel, there was just one thing I didn't understand about that game.", 1);
 Quip (-1, 0, Joel, "Yeah?", 1);
 Quip (-1, 0, Tom, "WHAT THE HECK WAS IT ABOUT!!", 1);
 Quip (-1, 0, Crow, "Yeah, like the Old Man who burns down the forest every year. And the baby falling out of the window. And worrying more about the poison ivy than the fact that you're in the middle of a raging forest fire, and a book that you can examine but can't read, even when it's unlocked, and a fish that opens up like it's on a hinge, and stuff. Even the cleavage scene was completely gratuitous, so maybe it wasn't all bad...", 1);
 Quip (-1, 0, Joel, "Well, it was just a maze you guys. That's all, nothing more. It was a maze that had a bunch of weird room descriptions instead of the old ~You are in a maze of twisty little passages~ stuff. The author made the descriptions different so that you wouldn't notice right away that that's what it was, and then gave identical descriptions to three rooms to confuse you. But then he gave you enough items to drop behind in the fog areas so that you could map the whole game in the traditional maze way once you figured it out.", 1);
 Quip (-1, 0, Crow, "But Joel, a maze isn't a game. It's just part of a game. And a really cheezy(tm) part at that. So, if it was a Fable, then what was the moral?", 1);
 Quip (-1, 0, Joel, "Don't you understand? The silver key said ~Wisdom~. And the locked book said ~Understanding.~ So, ~Wisdom~ is the ~Key~ to ~Understanding.~ You get it?", 1);
 Quip (-1, 0, Tom, "YOU MEAN WE PLAYED THROUGH THAT STINKBURGER JUST SO WE COULD GET A FORTUNE COOKIE MESSAGE?", 1);
 Quip (-1, 0, Joel, "Hey yeah, what's the big idea sirs?", 1);
 Deep13 ();
 Quip (-1, 1, Forrester, "Boobie, look. The games are supposed to taste bad. Otherwise they wouldn't be good for you.", 1);
 Quip (-1, 0, Frank, "Yeah, I liked it. It was bold. It was stark. It was progressive. A statement for the ages. A bold and plucky expose of life in modern society.", 1);
 SoL ();
 Quip (-1, 1, Joel, "No, it wasn't.", 1);
 Deep13 ();
 Quip (-1, 1, Forrester, "Look, what do you want from us? We're Evil!", 1);
 Quip (-1, 0, Both, "EVIL!", 1);
 Quip (-1, 0, Forrester, "Well, until next time, Jumpsuit Joelie. Push the button Frank.", 1);
 print "[Frank pushes the button]", (NewLine)1;
 PushTheButtonFrank ();
 print "[MST Love Theme plays]", (NewLine)1;
 print (FormatText)"%F%RSTINGER:%P";
 print (FormatText)"%F %R~What's the matter with you,~ he says. ~You never listen to anything I tell you. You think you're so smart. You're a bum just like your father. Never listen to me.~%P";
 NewLine (1);
 deadflag=4;	! You have won the game.
 rfalse;
];

! Intermission
! Displays the intermission this game has. After 15 turns, everywhere bar the frozen lake...
! ...and, of course, your front door.
[ Intermission;
 if (location has NoInt)
 {
  rfalse;	! If the location is one of the two where no intermission's allowed, return.
 }
 if (turns~=15)
 {
  rfalse;	! Likewise, this needs to be the 15th turn.
 }
 Quip (0, 1, Joel, "Intermission guys, we gotta go.", 1);
 WaitForKey ("[Press any key...]");
 ! CODE FOR PLAYING DOORS OUT WILL GO HERE.
 clrscr ();
 NewLine (1);
 print "[1...2...3...4...5...6...G...]";
 SoL ();
 print (NewLine)1, "[Crow is standing alone on stage, looking around]";
 Quip (0, 1, Tom, "[offscreen] This is the story of a robot. His name is Crow. Crow is confused, upset. Crow tiptoes out of his room and leaves his sleeping friends, perhaps for the last time. He doesn't know whether he's coming or going, the poor sap.", 1);
 Quip (0, 0, Crow, "Hey!", 2);
 Quip (0, 0, Tom, "Crow walks down a lonely road at midnight. An armadillo is hit by a passing car and lands at Crow's feet. Crow takes this moment to ponder the hypocrisy of the post-hermeneutical anthropomorphic neo-xanthic value system.", 2);
 Quip (0, 0, Tom, "Crow is now standing on his head in his front yard. Across the street, Old Man Brubaker is tending his flower garden. Suddenly, Old Man Brubaker clutches his chest and falls to the ground. Crow feels like he has learned a valuable lesson.", 2);
 Quip (0, 0, Tom, "Crow is on stage. He is wearing nothing but a loincloth and is attempting to eat an entire jeep piece by piece to make a protest against the decline of post avant-garde cubism. Crow weeps with pride at his performance.", 2);
 Quip (0, 0, Tom, "Crow's head is now shaved. He is sitting jackknifed in a plate of bean sprouts in the middle of the town square, trying to activate the movie sign button purely by the power of the mind...", 1);
 print "[Movie Sign light begins flashing]", (NewLine)1;
 print "[G...6...5...4...3...2...1...]", (NewLine)1;
! CODE TO PLAY SEGUE WILL GO HERE.
 WaitForKey ("[Press any key...]");
 clrscr ();
 NewLine (1);
 <Look>;
 rfalse;
];