
package org.ifarchive.glk;

/** A Glk dispatch integer constant.
 * @author John Elliott
 * @version 1.0 */

public class IntConstant 
{
	/** The name of this constant. */
	public String name;	
	/** And its value. */
	public long value;

	IntConstant(String n, long v)
	{
		name = n; value = v;
	}

	/** Return the number of integer constants.
	 * @return The number of integer constants in this Glk library. */
        public static int count()
        {
                return Glk.jnigidispatch_count_intconst();
        }
	/** Retrieve an integer constant.
	 * @param index The number of the integer constant, 0 - count
	 * @return The requested constant, or null if index is out of range
	 * @see #count()
	 */
        public static IntConstant get(int index)
        {
                return Glk.jnigidispatch_get_intconst(index);
        }

}
