/* gtsetup.c: Runtime configuration system
        for GlkDOS, curses.h/allegro implementation of the Glk API
    Designed by L. Ross Raszewski <lraszewski@justice.loyola.edu>
    
    based upon GlkTerm by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html
*/
#include "gtpref.h"
#include "gtoption.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cscr.h"
#include "glk.h"
#include "glkdos.h"
#include "gtw_buf.h"
#include "gtcolor.h"

void gt_start_setup()
{
 int done=0;
 int line=4;
 int cstyle=0;
 int c;
 int pager=(glk_preferences[pref_more_pager]==1) |
           ((glk_preferences[pref_rat_pager]==1) << 1) |
           ((glk_preferences[pref_per_pager]==1) << 2);
 static const char *stylen[] =
        { "Normal",
          "Emphasis",
          "Preformatted",
          "Header",
          "Subheader",
          "Alert",
          "Note",
          "BlockQuote",
          "Input",
          "User1",
          "User2",
          "Hyperlink" };
 while(!done)
{
 cscr_clear();
 cscr_moveyx(2,1);
 cscr_attrset(cscr_color(glk_preferences[pref_fg_color],glk_preferences[pref_bg_color]));
 cscr_printw("GlkDOS Configuration");
 cscr_moveyx(4,3);
 cscr_printw("Message Line [%s]\n\r",glk_preferences[pref_messageline] ? "YES" : "NO");
 cscr_printw("   Reverse textgrid [%s]\n\r",glk_preferences[pref_reverse_textgrids] ? "YES" : "NO");
 cscr_printw("   Pager [");
 if (pager==7) cscr_printw("ALL");
 else if (pager==0) cscr_printw("NONE");
 else {
  if (glk_preferences[pref_more_pager]) cscr_printw(" MORE");
  if (glk_preferences[pref_rat_pager]) cscr_printw(" FRACTION");
  if (glk_preferences[pref_per_pager]) cscr_printw(" PERCENT");
  cscr_addch(' ');
  }
 cscr_printw("]\n\r");
 cscr_printw("   Display window borders [%s]\n\r",glk_preferences[pref_window_borders] ? "YES" : "NO");
 cscr_printw("   Show links in %s windows\n\r",
                glk_preferences[pref_buf_link] ? (glk_preferences[pref_grid_link] ? "all" : "buffer")
                : (glk_preferences[pref_grid_link] ? "grid" : "no"));
 cscr_printw("   Sound (if available) [%s]\n\r",glk_preferences[pref_sound] ? "ON" : "OFF");
 cscr_printw("   Forground Color [%d]\n\r   Background Color [%d]\n\r",
         glk_preferences[pref_fg_color], glk_preferences[pref_bg_color]);
 cscr_printw("   Match background to style_Normal [%s]\n\r",glk_preferences[pref_normalize_wipe] ? "YES" : "NO");
 cscr_printw("   Set attributes for style: ");
{ chtype t=style_mask[cstyle];
        style_mask[cstyle]=def_style_mask[cstyle];
        setup_curses();
  cscr_attrset(win_textbuffer_styleattrs[cstyle]);
  style_mask[cstyle]=t;
  }
  cscr_printw("%s [%d]\n\r", stylen[cstyle], def_style_mask[cstyle]);
 cscr_attrset(cscr_color(glk_preferences[pref_fg_color],glk_preferences[pref_bg_color]));
 cscr_printw("    %soreground color %d %s\n\r", (def_style_mask[cstyle] & 0x0100)? "Default f" : "F" ,style_mask[cstyle] & 0x0f,(style_mask[cstyle] & 0x010000)? "(LOCKED)" : " ");
 cscr_printw("    %sackground color %d %s\n\r", (def_style_mask[cstyle] & 0x0200)? "Default b" : "B" ,(style_mask[cstyle] & 0xf0) >> 4, (style_mask[cstyle] & 0x020000)? "(LOCKED)" : " ");
 cscr_printw("    Force high intensity %s\n\r", (def_style_mask[cstyle] & 0x400000)? "(LOCKED)" : " ");
 cscr_printw("    Force low intensity %s\n\r", (def_style_mask[cstyle] & 0x200000)? "(LOCKED)" : " ");
 cscr_printw("    Reverse %s\n\r", (def_style_mask[cstyle] & 0x100000)? "(LOCKED)" : " ");
 cscr_printw("    Lock attributes\n\r");
 cscr_printw("   Apply these settings to all current windows\n\r");
 cscr_printw("   Write these settings to file\n\r");
 cscr_moveyx(line,1);
 cscr_addch('>');
 getinput:
 cscr_refresh();
 c=cscr_getch();
 switch(c)
 {
  case 'p':
  case 'P':
  case KEY_UP:
   cscr_moveyx(line,1); cscr_addch(' ');
   line--; if (line<4) line=21;
   break;
  case 'n':
  case 'N':
  case KEY_DOWN:
   cscr_moveyx(line,1); cscr_addch(' ');
   line++; if (line>21) line=4;
   break;
  case 'q':
  case 'Q':
  case '\033':
   done=1;
   break;
  case KEY_ENTER:

  case '\015': /* ctrl-M */
   switch(line)
   {
    case 4: glk_preferences[pref_messageline]=!glk_preferences[pref_messageline]; break;
    case 5: glk_preferences[pref_reverse_textgrids]=!glk_preferences[pref_reverse_textgrids];
            setup_curses();
            break;
    case 6: pager++; if (pager==8) pager=0;
       glk_preferences[pref_more_pager]=((pager & 1)==1);
       glk_preferences[pref_rat_pager]=((pager & 2)==2);
       glk_preferences[pref_per_pager]=((pager & 4)==4);
       break;
     case 7: glk_preferences[pref_window_borders]=!glk_preferences[pref_window_borders]; break;
     case 8:
             if (glk_preferences[pref_buf_link] && glk_preferences[pref_grid_link]) glk_preferences[pref_buf_link]=glk_preferences[pref_grid_link]=0;
             else if (glk_preferences[pref_grid_link] && !glk_preferences[pref_buf_link]) { glk_preferences[pref_buf_link]=1; glk_preferences[pref_grid_link]=0;}
             else glk_preferences[pref_grid_link]=1;
             break;
     case 9: glk_preferences[pref_sound]=!glk_preferences[pref_sound];
            break;
     case 10: 
             glk_preferences[pref_fg_color] = (glk_preferences[pref_fg_color] + 1) % 16;
             setup_curses();
             break;
     case 11: 
             glk_preferences[pref_bg_color] = (glk_preferences[pref_bg_color ]+ 1) % 16;
             setup_curses();
             break;
     case 12: glk_preferences[pref_normalize_wipe]=!glk_preferences[pref_normalize_wipe]; setup_curses();
                break;
     case 13: 
              cstyle = (cstyle + 1) % style_NUMSTYLES;
     break;
     case 14: if ((def_style_mask[cstyle]&0x0f) == 0x0f)
          { def_style_mask[cstyle]=(def_style_mask[cstyle] & 0xfffffff0) | 0x0100; }
           else if (def_style_mask[cstyle] & 0x100) def_style_mask[cstyle]&=~0x100;
          else def_style_mask[cstyle]++;
         style_mask[cstyle]=def_style_mask[cstyle];
             setup_curses();
          break;
     case 15: if ((def_style_mask[cstyle]&0xf0) == 0xf0)
          { def_style_mask[cstyle]=(def_style_mask[cstyle]&(0xffffff0f)) | 0x0200; }
              else if (def_style_mask[cstyle] & 0x200) def_style_mask[cstyle]&=~0x200;
          else def_style_mask[cstyle]+=0x10;
         style_mask[cstyle]=def_style_mask[cstyle];
             setup_curses();
          break;
     case 16: def_style_mask[cstyle]^=0x4000;
         style_mask[cstyle]=def_style_mask[cstyle];
             setup_curses();
        break;
     case 17: def_style_mask[cstyle]^=0x2000;
         style_mask[cstyle]=def_style_mask[cstyle];
             setup_curses();
        break;
     case 18: def_style_mask[cstyle]^=0x1000;
         style_mask[cstyle]=def_style_mask[cstyle];
             setup_curses();
        break;
     case 19: 
              
              def_style_mask[cstyle]+=0x010000;
              if (def_style_mask[cstyle]&0x040000)
                def_style_mask[cstyle]+=0x0C0000;
              if (def_style_mask[cstyle]>0x800000)
                def_style_mask[cstyle]&=0xffff;
              style_mask[cstyle]=def_style_mask[cstyle];
              break;
     case 20:
        {
          winid_t cw; 
          cw=glk_window_iterate(NULL,NULL);
          memcpy(style_mask,def_style_mask,style_NUMSTYLES*sizeof(chtype));
          setup_curses();
          while(cw)
          {
           memcpy(cw->winstyle,win_textbuffer_styleattrs,style_NUMSTYLES*sizeof(chtype));
           cw=glk_window_iterate(cw,NULL);

          }
         }
        break;
 case 21:
   {
     FILE *f; char s[100]; int l;
     l=7;
     sprintf(s,"glk.cfg");
     if (!gli_msgin_getline("Write to file > ",s,99,&l)) break;
     if (l==0) break;
     s[l]=0;
     f=fopen(s,"w");
     if (!f) {
        cscr_moveyx(20, 40);
        cscr_printw("Can not write file");
        cscr_getch();
        break;
        }
        fprintf(f,"MESSAGELINE ");
        if (glk_preferences[pref_messageline])
         fprintf(f,"ON");
        else fprintf(f,"OFF");
        fprintf(f,"\n");

        if (glk_preferences[pref_reverse_textgrids])
         fprintf(f,"REVERSE");
        else fprintf(f,"NORMAL");
        fprintf(f," GRID\nBORDER ");
        if (glk_preferences[pref_window_borders])
         fprintf(f,"ON");
        else fprintf(f,"OFF");
        fprintf(f,"\n");
        if (glk_preferences[pref_normalize_wipe])
         fprintf(f,"NORMALIZE");
        else fprintf(f,"DEFAULT");
        fprintf(f," BACKGROUND\nSOUND ");
        if (glk_preferences[pref_sound])
         fprintf(f,"ON");
        else fprintf(f,"OFF");
        fprintf(f,"\nMORE ");
        if (glk_preferences[pref_more_pager])
         fprintf(f,"ON");
        else fprintf(f,"OFF");
        fprintf(f,"\nFRACT ");
        if (glk_preferences[pref_rat_pager])
         fprintf(f,"ON");
        else fprintf(f,"OFF");
        fprintf(f,"\nPERCENT ");
        if (glk_preferences[pref_per_pager])
         fprintf(f,"ON");
        else fprintf(f,"OFF");
        fprintf(f,"\nFOREGROUND %d\nBACKGROUND %d\n",glk_preferences[pref_fg_color],glk_preferences[pref_bg_color]);
        fprintf(f,"NORMAL %d\nEMPHASIS %d\nPREFORMATTED %d\nHEADER %d\n",
                def_style_mask[style_Normal],
                def_style_mask[style_Emphasized],
                def_style_mask[style_Preformatted],
                def_style_mask[style_Header]);
        fprintf(f,"SUBHEADER %d\nALERT %d\nNOTE %d\nBLOCKQUOTE %d\nUSER1 %d\nUSER2 %d\n",
                def_style_mask[style_Subheader],
                def_style_mask[style_Alert],
                def_style_mask[style_Note],
                def_style_mask[style_BlockQuote],
                def_style_mask[style_User1],
                def_style_mask[style_User2]);
       fclose(f);
     
     
   }

   }
   break;
  default: goto getinput;
 }
  
}
        setup_curses();
        cscr_clear();
}
