#define applies_GridLine        1
#define applies_GridKey         2
#define applies_BufferLine      4
#define applies_BufferKey       8
#define applies_Always          16

#include "gtoption.h"
#include <stdio.h>
#include <stdlib.h>
#include "cscr.h"
#include "glk.h"
#include "glkdos.h"
#include "gtw_grid.h"
#include "gtw_buf.h"


typedef void (*command_fptr)(window_t *win, glui32);
typedef struct command_struct {
    command_fptr func;
    int arg;
} command_t;

typedef struct
{
 char *cmd_name;
 int applies;
 command_t buf_cmd;
 command_t grd_cmd;
 command_t cmd;
} bound_key;

void gcmd_command(window_t *win, glui32);
void gcmd_reveal_codes(window_t *win, glui32);
void gcmd_start_setup(window_t *win, glui32);
void gcmd_shell(window_t *win, glui32);
void gcmd_grid_arbitrary_line(window_t *win, glui32);
void gcmd_buffer_arbitrary_line(window_t *win, glui32);
void gcmd_get_link(window_t *win, glui32);
static const bound_key key_commands[] = {
 { "toggle_overwrite", applies_Always,{NULL,0}, {NULL,0}, {gcmd_buffer_toggle_overwrite,0}},
 { "reveal_codes", applies_Always, {NULL,0}, {NULL,0}, {gcmd_reveal_codes,0}},
 { "shell", applies_Always, {NULL,0}, {NULL,0}, {gcmd_shell,0}},
 { "change_focus", applies_Always, {NULL,0}, {NULL,0}, {gcmd_win_change_focus,0}},
 { "refresh", applies_Always, {NULL,0}, {NULL,0}, {gcmd_buffer_toggle_overwrite,0}},
 { "setup", applies_Always, {NULL,0}, {NULL,0}, {gcmd_start_setup,0}},
 { "exec_command", applies_Always, {NULL,0}, {NULL,0}, {gcmd_command,0}},
 { "accept_key", applies_GridKey | applies_BufferKey, {gcmd_buffer_accept_key, -1}, {gcmd_grid_accept_key, -1}, {NULL,0}},
 { "insert_key", applies_BufferLine | applies_GridLine, {gcmd_buffer_insert_key, -1}, {gcmd_grid_insert_key, -1}, {NULL,0}},
 { "arbitrary_key", applies_BufferLine | applies_GridLine, { gcmd_buffer_arbitrary_line, 0}, {gcmd_grid_arbitrary_line, 0} , {NULL,0}},
 { "accept_line", applies_BufferLine | applies_GridLine, { gcmd_buffer_accept_line, 0}, {gcmd_grid_accept_line, 0} , {NULL,0}},
 { "move_left", applies_BufferLine | applies_GridLine,   { gcmd_buffer_move_cursor, gcmd_Left },{ gcmd_grid_move_cursor, gcmd_Left }, {NULL,0}},
 { "move_right", applies_BufferLine | applies_GridLine,   { gcmd_buffer_move_cursor, gcmd_Right },{ gcmd_grid_move_cursor, gcmd_Right }, {NULL,0}},
 { "begin_line", applies_BufferLine | applies_GridLine,  { gcmd_buffer_move_cursor, gcmd_LeftEnd },{ gcmd_grid_move_cursor, gcmd_LeftEnd }, {NULL,0}},
 { "end_line", applies_BufferLine | applies_GridLine,  { gcmd_buffer_move_cursor, gcmd_RightEnd },{ gcmd_grid_move_cursor, gcmd_RightEnd }, {NULL,0}},
 { "delete_backward", applies_BufferLine | applies_GridLine,  { gcmd_buffer_delete, gcmd_Delete },{ gcmd_grid_delete, gcmd_Delete }, {NULL,0}},
 { "delete_forward", applies_BufferLine | applies_GridLine,  { gcmd_buffer_delete, gcmd_DeleteNext },{ gcmd_grid_delete, gcmd_DeleteNext }, {NULL,0}},
 { "undo_line", applies_BufferLine | applies_GridLine,  { gcmd_buffer_delete, gcmd_KillInput },{ gcmd_grid_delete, gcmd_KillInput }, {NULL,0}},
 { "kill_line", applies_BufferLine | applies_GridLine,   { gcmd_buffer_delete, gcmd_KillLine },{ gcmd_grid_delete, gcmd_KillLine}, {NULL,0}},
 { "scroll_to_top", applies_BufferKey | applies_BufferLine,  { gcmd_buffer_scroll, gcmd_UpEnd },{NULL,0}, {NULL,0}},
 { "scroll_to_bottom", applies_BufferKey | applies_BufferLine, { gcmd_buffer_scroll, gcmd_DownEnd },{NULL,0}, {NULL,0}},
 { "scroll_up", applies_BufferLine, { gcmd_buffer_scroll, gcmd_Up },{NULL,0}, {NULL,0}},
 { "scroll_down", applies_BufferLine,  { gcmd_buffer_scroll, gcmd_Down },{NULL,0}, {NULL,0}},
 { "page_up", applies_BufferLine,  { gcmd_buffer_scroll, gcmd_UpPage },{NULL,0}, {NULL,0}},
 { "page_down", applies_BufferLine,  { gcmd_buffer_scroll, gcmd_DownPage },{NULL,0}, {NULL,0}},
 { "history_prev", applies_BufferLine,{ gcmd_buffer_history, gcmd_Up }, {NULL,0}, {NULL,0}},
 { "history_next", applies_BufferLine, { gcmd_buffer_history, gcmd_Down }, {NULL,0}, {NULL,0}},
 { "set_macro_1", applies_BufferLine, { gcmd_buffer_setmacro, 0 }, {NULL,0}, {NULL,0}},
 { "set_macro_2", applies_BufferLine, { gcmd_buffer_setmacro, 1 }, {NULL,0}, {NULL,0}},
 { "set_macro_3", applies_BufferLine, { gcmd_buffer_setmacro, 2 }, {NULL,0}, {NULL,0}},
 { "set_macro_4", applies_BufferLine,{ gcmd_buffer_setmacro, 3 }, {NULL,0}, {NULL,0}},
 { "macro_1", applies_BufferLine,{ gcmd_buffer_domacro, 0 }, {NULL,0}, {NULL,0}},
 { "macro_2", applies_BufferLine,{ gcmd_buffer_domacro, 1 }, {NULL,0}, {NULL,0}},
 { "macro_3", applies_BufferLine,{ gcmd_buffer_domacro, 2 }, {NULL,0}, {NULL,0}},
 { "macro_4", applies_BufferLine,{ gcmd_buffer_domacro, 3 }, {NULL,0}, {NULL,0}},
 { "buffer_extract", applies_BufferLine,{ gcmd_buffer_paste, 0 }, {NULL,0}, {NULL,0}},
 { "buffer_wipe", applies_BufferLine,{ gcmd_buffer_cutcopy, 1 }, {NULL,0}, {NULL,0}},
 { "buffer_save", applies_BufferLine,{ gcmd_buffer_cutcopy, 0 }, {NULL,0}, {NULL,0}},
 { "set_mark", applies_BufferLine,{ gcmd_buffer_setmark, 0 }, {NULL,0}, {NULL,0}},
 { "get_link", applies_Always, {NULL,0}, {NULL,0}, { gcmd_get_link, 0 }},
 { NULL, 0, {NULL,0},{NULL,0}, {NULL,0}}
};

struct keybinding
{
 int key;
 bound_key cmd;
};

static struct keybinding *user_keys=NULL;
static int user_keybindings=0;
command_t *command_user(window_t *win, int key, int reveal_codes)
{
 int i;
 for(i=0;i<user_keybindings;i++)
  if (user_keys[i].key==key)
  {
    if (user_keys[i].cmd.applies & applies_Always)
    {
     if (reveal_codes) gli_msgline_tick(user_keys[i].cmd.cmd_name);
     return &user_keys[i].cmd.cmd;
    }
    else if (win->line_request)
    {
     if (win->type==wintype_TextGrid && (user_keys[i].cmd.applies & applies_GridLine))
     {
      if (reveal_codes) gli_msgline_tick(user_keys[i].cmd.cmd_name);
      return &user_keys[i].cmd.grd_cmd;
     }
     else if (win->type==wintype_TextBuffer && (user_keys[i].cmd.applies & applies_BufferLine))
     {
      if (reveal_codes) gli_msgline_tick(user_keys[i].cmd.cmd_name);
      return &user_keys[i].cmd.buf_cmd;
     }
    }
    if (win->type==wintype_TextBuffer && (user_keys[i].cmd.applies & applies_BufferKey))
     {
      if (reveal_codes) gli_msgline_tick(user_keys[i].cmd.cmd_name);
      return &user_keys[i].cmd.buf_cmd;
     }
    else if (win->type==wintype_TextGrid && (user_keys[i].cmd.applies & applies_GridKey))
     {
      if (reveal_codes) gli_msgline_tick(user_keys[i].cmd.cmd_name);
      return &user_keys[i].cmd.grd_cmd;
     }
  }

  return NULL;
}

int bind_key(char *s, int key)
{
 int i=user_keybindings;
 const bound_key *k;

 for(k=key_commands;k->cmd_name;k++)
  if (!strcmp(k->cmd_name,s))
   break;
 if (!(k->cmd_name)) return 0;

 user_keybindings++;
 user_keys=(struct keybinding *)realloc(user_keys,user_keybindings * sizeof
           (struct keybinding));
 user_keys[i].key=key;
 user_keys[i].cmd=*k;
 return user_keybindings;
}
