/* gtcolor.c: CSCR setup and and color allocation controls
        for GlkDOS, curses.h/allegro implementation of the Glk API
    Designed by L. Ross Raszewski <lraszewski@justice.loyola.edu>
    
    based upon GlkTerm by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html
*/
#include "gtpref.h"
#include <stdlib.h>
#include <string.h>
#include "gtoption.h"
#include <stdio.h>
#include "cscr.h"
#include "glk.h"
#include "glkdos.h"
int gli_bg_color;
extern chtype win_textgrid_styleattrs[];
extern chtype win_textbuffer_styleattrs[];

unsigned int style_mask[style_NUMSTYLES+1]=  //AABF  A=BLR A=BF
                    {
                        
                     0x0300,
                     0x020e,
                     0x0300,
                     0x4300,
                     0x4300,
                     0x5300,
                     0x0202,
                     0x1300,
                     0x4300,
                     0x1300,
                     0x0206,
                     0x0204

                     };
unsigned int old_style_mask[style_NUMSTYLES+1]=  //AABF  A=BLR A=BF
                    {
                        
                     0x0300,
                     0x020e,
                     0x0300,
                     0x4300,
                     0x4300,
                     0x5300,
                     0x0202,
                     0x1300,
                     0x4300,
                     0x1300,
                     0x0206,
                     0x0204
                     };

unsigned int def_style_mask[style_NUMSTYLES+1]=  //AABF  A=BLR A=BF
                    {
                        
                     0x0300,
                     0x020e,
                     0x0300,
                     0x4300,
                     0x4300,
                     0x5300,
                     0x0202,
                     0x1300,
                     0x4300,
                     0x1300,
                     0x0206,
                     0x0204
                     };


unsigned char styletocolor(glui32 style)
{
 unsigned char color=style & 0xff;
 unsigned char mask=style >> 8;
 if (mask & 1) color=(color & 0xf0) | glk_preferences[pref_fg_color];
 if (mask & 2) color=(color & 0x0f) | (glk_preferences[pref_bg_color] << 4);
 mask = mask >> 4;
 if (mask & 1) color=((color & 0x0f) << 4) | ((color & 0xf0) >> 4);
 if (mask & 2) color=color & 0xf7;
 if (mask & 4) color=color | 0x08;
 return color;
}

void setup_curses()
{
    int ix;
    chtype bk;


    memcpy(old_style_mask,style_mask,style_NUMSTYLES*sizeof(chtype));
    /* Create the curses.h attribute values for each style. */
    for (ix=0; ix<style_NUMSTYLES; ix++) {
        chtype val = 0; 
        unsigned char color=styletocolor(style_mask[ix]);

        val = cscr_color(color & 0xf, color >> 4);
        win_textbuffer_styleattrs[ix] = val;

        if (glk_preferences[pref_reverse_textgrids])
            val ^= A_REVERSE;
        win_textgrid_styleattrs[ix] = val;
    }
    gli_bg_color=(glk_preferences[pref_normalize_wipe]) ?
        styletocolor(style_mask[style_Normal]) >> 4 :
        glk_preferences[pref_bg_color];
    bk=cscr_color(glk_preferences[pref_fg_color],gli_bg_color) | ' ';
        
    bk &= ~A_BOLD;
    cscr_bkgd(bk);
}

void gli_setup_curses()
{
    cscr_start();
}
