
#include <stdio.h>
#include <stdlib.h>

#include "pickle.h"
#include "picklewr.h"

#ifdef __STDC__
void undump_file(char *infilenm, char *outfilenm);
#else
void undump_file();
#endif

#ifdef __STDC__
main(int argc, char *argv[])
#else
main(argc, argv)
int argc;
char *argv[];
#endif
{
	int ix;
	
	if (argc != 3) {
		fprintf(stderr, "usage: pikmake infile outfile\n");
		fprintf(stderr, "Creates a PICKLE file from a directory file.\n");
		exit(-1);
	}

	undump_file(argv[1], argv[2]);
}

#ifdef __STDC__
static char *skipwhite(char *cx)
#else
static char *skipwhite(cx)
char *cx;
#endif
{
	while (*cx == ' ' || *cx == '\n' || *cx == '\r' || *cx == '\t')
		cx++;
		
	return cx;
}

#ifdef __STDC__
static char *skipnonwhite(char *cx)
#else
static char *skipnonwhite(cx)
char *cx;
#endif
{
	while (!(*cx == ' ' || *cx == '\n' || *cx == '\r' || *cx == '\t' || *cx == '\0'))
		cx++;
		
	return cx;
}

#ifdef __STDC__
static char *sucktype(char *cx, pikType *ret, long lnum)
#else
static char *sucktype(cx, ret, lnum)
char *cx;
pikType *ret;
long lnum;
#endif
{
	char buf[4];
	int ix;
	
	cx = skipwhite(cx);
	
	for (ix=0; ix<4; ix++) {
		if (*cx == '\\') {
			cx++;
			if (*cx == '\0' || *cx == '\n' || *cx == '\r') {
				fprintf(stderr, "%ld: Backslash at end of line.\n", lnum);
				return NULL;
			}
		}
		else if (*cx == '\0' || *cx == ' ' || *cx == '\n' || *cx == '\r' || *cx == '\t') {
			fprintf(stderr, "%ld: A type was found which was less than 4 characters.\n", lnum);
			return NULL;
		}
		buf[ix] = (*cx++);
	}
	
	*ret = pikMakeType(buf[0], buf[1], buf[2], buf[3]);
	
	return cx;
}

#ifdef __STDC__
static char *sucknumber(char *cx, pikLong *ret, long lnum)
#else
static char *sucknumber(cx, ret, lnum)
char *cx;
pikLong *ret;
long lnum;
#endif
{
	pikLong val = 0;
	int ix;
	
	cx = skipwhite(cx);
	if (!(*cx >= '0' && *cx <= '9')) {
		fprintf(stderr, "%ld: Number expected.\n", lnum);
		return NULL;
	}
	
	while (*cx >= '0' && *cx <= '9') {
		val = (val * 10) + (*cx - '0');
		cx++;
	}
	
	if (!(*cx == '\0' || *cx == ' ' || *cx == '\n' || *cx == '\r' || *cx == '\t')) {
		fprintf(stderr, "%ld: Non-numeric character in number.\n", lnum);
		return NULL;
	}
	
	*ret = val;
	return cx;	
}

#ifdef __STDC__
void undump_file(char *infilenm, char *outfilenm)
#else
void undump_file(infilenm, outfilenm)
char *infilenm;
char *outfilenm;
#endif
{
	FILE *infile, *outfile;
	long count;
	pikErr perr;
	char *cx, *fname;
	pikType use;
	pikFormat format;
	pikLong number;
	pikLong filestart, filelength;
	pikBuilderPtr map;
	long lnum;
	short finished;
	char buffer[256];
	char typebuf[5], typebuf2[5];
	
	infile = fopen(infilenm, "r");
	if (!infile) {
		fprintf(stderr, "Unable to open %s.\n", infilenm);
		return;
	}
	
	perr = pikxCreateBuilder(&map);
	if (perr) {
		fprintf(stderr, "Unable to create builder.\n");
		fclose(infile);
		return;
	}
	
	lnum = 0;
	finished = FALSE;
	while (1) {
		lnum++;
		cx = fgets(buffer, 256, infile);
		if (!cx) {
			/* End of file */
			finished = TRUE;
			break;
		}
		
		cx = skipwhite(cx);
		if (*cx == '\0' || *cx == '#' || *cx == '!') {
			/* Blank line or comment */
			continue;
		}
		
		cx = sucktype(cx, &use, lnum);
		if (!cx)
			break;

		cx = sucknumber(cx, &number, lnum);
		if (!cx)
			break;

		cx = sucktype(cx, &format.name, lnum);
		if (!cx)
			break;
			
		cx = sucknumber(cx, &format.version, lnum);
		if (!cx)
			break;

		cx = skipwhite(cx);
		if (*cx == '\0') {
			fprintf(stderr, "%ld: Filename expected.\n", lnum);
			break;
		}
		fname = cx;
		cx = skipnonwhite(cx);
		if (*cx != '\0') {
			*cx = '\0';
			cx++;
		}
		cx = skipwhite(cx);
		if (*cx == '\0') {
			filestart = 0;
			filelength = (-1);
		}
		else {
			cx = sucknumber(cx, &filestart, lnum);
			if (!cx)
				break;
			cx = sucknumber(cx, &filelength, lnum);
			if (!cx)
				break;
		}
		
		perr = pikxBuilderAdd(map, NULL, use, number, format, filestart, filelength, fname);
		if (perr) {
			fprintf(stderr, "Error processing directory.\n");
			break;
		}
		
		pikxTypeToString(use, typebuf);
		pikxTypeToString(format.name, typebuf2);
		printf("Adding chunk %s %ld (%s %ld)\n",
			typebuf, number, typebuf2, format.version);
		
	}

	fclose(infile);
	
	if (finished) {
		outfile = fopen(outfilenm, "wb");
		if (!outfile) {
			fprintf(stderr, "Unable to open %s.\n", outfilenm);
			pikxDestroyBuilder(map);
			return;
		}

		perr = pikxBuilderBuild(map, outfile);
		if (perr) {
			fprintf(stderr, "Unable to write %s.\n", outfilenm);
			pikxDestroyBuilder(map);
			fclose(outfile);
			return;
		}
		
		fclose(outfile);
	}
	
	pikxDestroyBuilder(map);
}
