/* Compile.h - compiler definitions */
/*
	Copyright (c) 1993, by David Michael Betz
	All rights reserved
*/

/* limits */
#define TKNSIZE		255	/* maximum token size */

/* useful definitions */
#define TRUE		1
#define FALSE		0

/* token definitions */
#define T_OPEN		1
#define T_CLOSE		2
#define T_QUOTE		3
#define T_STRING	4
#define T_IDENTIFIER	5
#define T_NUMBER	6
#define T_EOF		7

/* argument structure */
typedef struct argument {
    char *arg_name;		/* argument name */
    struct argument *arg_next;	/* next argument */
} ARGUMENT;

/* argument table structure */
typedef struct atable {
    ARGUMENT *at_arguments;	/* first argument */
    struct atable *at_next;	/* next argument table */
} ATABLE;
