import java.io.*;
import java.util.*;
import java.util.jar.*;

public class JarExtractor {
	private String jarName;
	private JarFile jarFile;
	private String outputDir;


	public JarExtractor(String in_jarName, String in_outputDir) throws Exception {
		this.jarName = in_jarName;
	    this.outputDir = in_outputDir;
        this.jarFile = new JarFile(jarName);
	}// end constructor

	public void extract() throws Exception{
		try {
			// Get the entry and its input stream.
			Enumeration<JarEntry> entries = jarFile.entries();
			JarEntry entry = null;

			while (entries.hasMoreElements() ) {
				entry = entries.nextElement();

				// If the entry is not null, extract it. Otherwise, print a 
				// message.
				if (entry != null && !entry.getName().contains("META-INF")) {
					if (entry.isDirectory()) {
						File dir = new File(outputDir + entry.getName()); 
						dir.mkdir();
					} else {
						// Get an input stream for the entry.
						InputStream entryStream = jarFile.getInputStream(entry);

						try {
							// Create the output file (clobbering the file if it exists).
							FileOutputStream file = new FileOutputStream(outputDir + entry.getName());

							try {
								// Allocate a buffer for reading the entry data.
								byte[] buffer = new byte[1024];
								int bytesRead;

								// Read the entry data and write it to the output file.
								while ((bytesRead = entryStream.read(buffer)) != -1) {
									file.write(buffer, 0, bytesRead);
								}

								System.out.println(outputDir + entry.getName() + " extracted.");
							} finally {
								file.close();
							}
						} finally {
							entryStream.close();
						}
					}
				}
			}// end for(entry:entries)
		}finally {
			jarFile.close();
			System.out.println(jarName + " closed.");
		}
	}// end extract()

	public JarFile getJarFile() {
		return this.jarFile;
	}

	public void setJarFile(JarFile in_jarFile) {
		this.jarFile = in_jarFile;
	}

	public String getJarName() {
		return this.jarName;
	}

	public String getOutputDir() {
		return this.outputDir;
	}

	public void setOutputDir(String new_outputDir) {
		this.outputDir = new_outputDir;
	}

	public void setJarName(String new_jarName) throws java.io.IOException {
		this.jarName = new_jarName;
		this.jarFile = new JarFile(this.jarName);
	}
		
}

