import bsh.Interpreter;
import java.io.*;
import java.util.*;

public class BagsLauncher {

	public static void main(String[] args) {
		try {
			String BAGS_HOME=System.getenv("BAGS_HOME");
			String BAGS_GAMES=System.getenv("BAGS_GAMES");

			Interpreter i = new Interpreter();
			i.set("BAGS_HOME", BAGS_HOME);
			i.set("BAGS_GAMES", BAGS_GAMES);
			if (args.length > 0) {
				i.set("jarFileName", args[0]);
			} else {
				i.set("jarFileName", "");
			}

			String bh = BAGS_HOME.replaceAll("\\\\", "/");
			i.eval("cd(\"" + bh + "/bin\")");
			i.source("BAGSMain.bsh");

			String gameId = (String)i.get("bagsMain.gameId");
			BAGS_GAMES = (String)i.get("BAGS_GAMES");

			// Load the properties
			String homedir = System.getenv("HOME");
			File homeFile = new File(homedir);
			Properties props = new Properties();
			if (homeFile.isDirectory()) {
				File bagsrc = new File(homedir + "/.bagsrc");
				if (bagsrc.exists()) {
					try {
						props.load(new FileInputStream(homedir + "/.bagsrc"));

						Enumeration properties = props.propertyNames();
						while( properties.hasMoreElements() )  {
							String theProperty = (String)properties.nextElement();
							i.set(theProperty, props.getProperty(theProperty));
						}
					} catch (Exception ex) {
						ex.printStackTrace();
					}
				}
			}

			// Load the properties
			props = new Properties();
			props.load(new FileInputStream(BAGS_GAMES + gameId + "/bags.properties"));

			Enumeration properties = props.propertyNames();
			while( properties.hasMoreElements() )  {
				String theProperty = (String)properties.nextElement();
				i.set(theProperty, props.getProperty(theProperty));
			}

			i.eval("bagsMain.runGame()");
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
