import java.io.File;
import javax.swing.*;
import javax.swing.filechooser.*;

public class BAGSGameFilter extends FileFilter {

    //Accept all directories and all gif, jpg, tiff, or png files.
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }

        String extension = BAGSUtils.getExtension(f);
        if (extension != null) {
            if (extension.equals(BAGSUtils.jar) ||
                extension.equals(BAGSUtils.properties) ) {
                    return true;
            } else {
                return false;
            }
        }

        return false;
    }

    //The description of this filter
    public String getDescription() {
        return "BAGS Game files";
    }
}

