import java.awt.Graphics;
import java.awt.Rectangle;

import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;

/**
 * BAGSBoxCaret
 * @author wadla001
 *
 */
public class BAGSBoxCaret extends DefaultCaret {

    /* (non-Javadoc)
     * @see javax.swing.text.Caret#paint(java.awt.Graphics)
     */
    public void paint(Graphics g) {
        if(isVisible()) {
            try {
                TextUI mapper = getComponent().getUI();
                Rectangle r = mapper.modelToView(getComponent(), getDot());
                g.setColor(getComponent().getCaretColor());
                g.fillRect(r.x, r.y, r.width+4, r.height+4);

                // force repaint region to match where we last painted            //ibm.3526
                x = r.x;                                                      //ibm.3526
                y = r.y;                                                          //ibm.3526
                width = r.width+4;
                height = r.height+4;                                                //ibm.3526

            } catch (BadLocationException e) {
                // can't render I guess
                //System.err.println("Can't render cursor");
            }
        }
    }
    /**
     * Damages the area surrounding the caret to cause
     * it to be repainted in a new location.  If paint()
     * is reimplemented, this method should also be
     * reimplemented.  This method should update the
     * caret bounds (x, y, width, and height).
     *
     * @param r  the current location of the caret
     * @see #paint
     */
    protected synchronized void damage(Rectangle r) {
        if (r != null) {
            x = r.x;
            y = r.y;
            width = r.width+4;
            height = r.height+4;
            repaint();
        }
    }    

}

