/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarExtractor {
    private String jarName;
    private JarFile jarFile;
    private String outputDir;

    public JarExtractor(String string, String string2) throws Exception {
        this.jarName = string;
        this.outputDir = string2;
        this.jarFile = new JarFile(this.jarName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract() throws Exception {
        try {
            Enumeration<JarEntry> enumeration = this.jarFile.entries();
            JarEntry jarEntry = null;
            while (enumeration.hasMoreElements()) {
                Object object;
                jarEntry = enumeration.nextElement();
                if (jarEntry == null || jarEntry.getName().contains("META-INF")) continue;
                if (jarEntry.isDirectory()) {
                    object = new File(this.outputDir + jarEntry.getName());
                    ((File)object).mkdir();
                    continue;
                }
                object = this.jarFile.getInputStream(jarEntry);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.outputDir + jarEntry.getName());
                    try {
                        int n;
                        byte[] byArray = new byte[1024];
                        while ((n = ((InputStream)object).read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                        System.out.println(this.outputDir + jarEntry.getName() + " extracted.");
                    }
                    finally {
                        fileOutputStream.close();
                    }
                }
                finally {
                    ((InputStream)object).close();
                }
            }
        }
        finally {
            this.jarFile.close();
            System.out.println(this.jarName + " closed.");
        }
    }

    public JarFile getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String string) {
        this.outputDir = string;
    }

    public void setJarName(String string) throws IOException {
        this.jarName = string;
        this.jarFile = new JarFile(this.jarName);
    }
}

