/*
 * Decompiled with CFR 0.152.
 */
package mdh.leastxml;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import mdh.leastxml.XMLException;

public class XMLNode {
    public static final String[][] ESCAPE = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}, {"\"", "&quot;"}, {"'", "&apos;"}};
    private String name_;
    private String attrs_;
    private Vector children_;

    public XMLNode() {
    }

    public XMLNode(String name) {
        this.name_ = name;
    }

    public XMLNode add(XMLNode child) {
        return this.addObject(child);
    }

    public XMLNode add(String child) {
        return this.addObject(child);
    }

    private XMLNode addObject(Object o) {
        if (this.children_ == null) {
            this.children_ = new Vector(1);
        }
        this.children_.addElement(o);
        return this;
    }

    public static String escape(String text) {
        int len = ESCAPE.length;
        for (int i = 0; i < len; ++i) {
            text = XMLNode.replace(text, ESCAPE[i][0], ESCAPE[i][1]);
        }
        return text;
    }

    public String getAttrs() {
        return this.attrs_;
    }

    public Object getChild(int i) throws XMLException {
        if (this.children_ == null || i < 0 || i >= this.children_.size()) {
            throw new XMLException("Invalid index " + i + " out of " + this.size());
        }
        return this.children_.elementAt(i);
    }

    public String getChildString(int i) throws XMLException {
        Object o = this.getChild(i);
        if (!(o instanceof String)) {
            throw new XMLException("Expected String, but was " + o);
        }
        return (String)o;
    }

    public XMLNode getChildXMLNode(int i) throws XMLException {
        Object o = this.getChild(i);
        if (!(o instanceof XMLNode)) {
            throw new XMLException("Expected XMLNode, but was " + o);
        }
        return (XMLNode)o;
    }

    public Vector getChildren() {
        return this.children_;
    }

    public String getName() {
        return this.name_;
    }

    public Properties parseAttrs() throws XMLException {
        Properties props = new Properties();
        String s = this.attrs_;
        if (s == null) {
            return props;
        }
        int i = 0;
        int len = s.length();
        while (i < len) {
            if (Character.isWhitespace(s.charAt(i))) {
                ++i;
                continue;
            }
            int start = i;
            int eq = s.indexOf(61, start);
            if (eq < 0) {
                throw new XMLException("Malformed attribute " + s.substring(start) + " in " + this);
            }
            char quote = s.charAt(eq + 1);
            int endquote = s.indexOf(quote, eq + 2);
            if (endquote < 0) {
                throw new XMLException("Malformed attribute " + s.substring(start) + " in " + this);
            }
            i = endquote + 1;
            String name = s.substring(start, eq);
            String value = XMLNode.unescape(s.substring(eq + 2, endquote));
            props.setProperty(name, value);
        }
        return props;
    }

    public static String replace(String text, String find, String replace) {
        int index = text.indexOf(find);
        if (index < 0) {
            return text;
        }
        int textlen = text.length();
        int findlen = find.length();
        StringBuffer sb = new StringBuffer(textlen + 32);
        int last = 0;
        do {
            if (index > last) {
                sb.append(text.substring(last, index));
            }
            sb.append(replace);
            last = index + findlen;
        } while ((index = text.indexOf(find, index + findlen)) >= 0);
        sb.append(text.substring(last));
        text = sb.toString();
        return text;
    }

    public XMLNode setAttrs(String a) {
        this.attrs_ = a;
        return this;
    }

    public XMLNode setAttrs(Properties props) {
        if (props == null) {
            this.attrs_ = null;
        } else {
            StringBuffer sb = new StringBuffer(props.size() * 16);
            boolean first = false;
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                char quote;
                String key = (String)e.nextElement();
                String value = props.getProperty(key);
                char c = quote = value.indexOf(34) >= 0 ? (char)'\'' : '\"';
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                }
                sb.append(key).append('=');
                sb.append(quote).append(XMLNode.escape(value)).append(quote);
            }
            this.attrs_ = sb.toString();
        }
        return this;
    }

    public XMLNode setName(String n) {
        this.name_ = n;
        return this;
    }

    public int size() {
        return this.children_ == null ? 0 : this.children_.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuffer sb) {
        int size = this.size();
        if (this.name_ != null) {
            sb.append('<').append(this.name_);
            if (this.attrs_ != null) {
                sb.append(' ').append(this.attrs_);
            }
            if (size == 0) {
                sb.append(" />");
            } else {
                sb.append('>');
            }
        }
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                Object child = this.children_.elementAt(i);
                if (child instanceof XMLNode) {
                    ((XMLNode)child).toString(sb);
                    continue;
                }
                String s = (String)child;
                sb.append(s);
            }
            if (this.name_ != null) {
                sb.append("</").append(this.name_).append('>');
            }
        }
    }

    public static String unescape(String text) {
        int len = ESCAPE.length;
        for (int i = 0; i < len; ++i) {
            text = XMLNode.replace(text, ESCAPE[i][1], ESCAPE[i][0]);
        }
        return text;
    }
}

