/*
 * Decompiled with CFR 0.152.
 */
package mdh.aiee;

import java.io.Serializable;
import java.util.ArrayList;
import mdh.aiee.Adventure;
import mdh.aiee.Stuff;

public class Command
implements Serializable {
    public static final int FALLTHRU = 0;
    public static final int CONTINUE = 1;
    public static final int ABORT = 2;
    public static final int FALSE = 3;
    public static final int TRUE = 4;
    private String name_;
    private ArrayList cmds_;

    public Command(String name) {
        this.name_ = name;
    }

    public void addCommand(Command cmd) {
        if (this.cmds_ == null) {
            this.cmds_ = new ArrayList(1);
        }
        this.cmds_.add(cmd);
    }

    public int countCommands() {
        return this.cmds_ == null ? 0 : this.cmds_.size();
    }

    public final int doEval(Adventure adv, Stuff _this) {
        if (adv.getDebug()) {
            System.err.println("<" + this.name_ + ">");
        }
        adv.setVarString("_this", _this == null ? "" : _this.id());
        return this.eval(adv);
    }

    protected int eval(Adventure adv) {
        return this.evalCommands(adv);
    }

    protected final int evalCommands(Adventure adv) {
        Stuff _this = adv.getStuff(adv.getVarString("_this"));
        int len = this.countCommands();
        for (int i = 0; i < len; ++i) {
            Command cmd = this.getCommand(i);
            int rc = cmd.doEval(adv, _this);
            if (rc == 0) continue;
            return rc;
        }
        return 0;
    }

    public Command getCommand(int i) {
        return (Command)this.cmds_.get(i);
    }

    public String getName() {
        return this.name_;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append('<').append(this.name_);
        this.toString2(sb);
        this.toStringCommands(sb);
        sb.append('<').append('/').append(this.name_).append('>');
        return sb.substring(0);
    }

    protected void toString2(StringBuffer sb) {
        sb.append('>');
    }

    public void toStringCommands(StringBuffer sb) {
        int len = this.countCommands();
        for (int i = 0; i < len; ++i) {
            Command cmd = this.getCommand(i);
            if (i == 0) {
                sb.append('\n');
            }
            sb.append(cmd).append('\n');
        }
    }
}

