/*
 * Decompiled with CFR 0.152.
 */
package mdh.aiee;

import java.applet.AudioClip;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.Icon;
import mdh.aiee.Adventure;
import mdh.aiee.Global;
import mdh.aiee.Parser;

public abstract class Aiee
implements Runnable {
    protected static final int TEXTCOLUMNS = 80;
    protected static final int TEXTROWS = 24;
    private boolean dump_;
    private boolean debug_;
    private String filename_;
    private PrintWriter logger_;
    private boolean playing_;
    private int columns_ = 80;
    private int rows_ = 24;

    public Aiee() {
        Adventure.getAdv().setEnvironment(this);
    }

    public int getColumns() {
        return this.columns_;
    }

    public int getRows() {
        return this.rows_;
    }

    public boolean getDebug() {
        return this.debug_;
    }

    public boolean getDump() {
        return this.dump_;
    }

    public String getFilename() {
        return this.filename_;
    }

    public void init(String[] args) {
        this.parseArgs(args);
        this.initDisplay();
        this.loadGame(this.getFilename());
        this.setPlaying(true);
        this.start();
    }

    public void initDisplay() {
        this.println("Aiee! v0.2");
    }

    public boolean isLogging() {
        return this.logger_ != null;
    }

    public boolean isPlaying() {
        return this.playing_;
    }

    public void loadGame(String filename) {
        File file;
        File file2 = file = filename != null ? new File(filename) : null;
        if (file != null) {
            if (!file.exists()) {
                this.println(filename + " does not exist!");
                file = null;
            } else if (!filename.endsWith(".xml")) {
                this.println(filename + " is not an Aiee! adventure!");
                file = null;
            }
        }
        if (file == null) {
            File pwd = new File(System.getProperty("user.dir"));
            String[] filenames = pwd.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
            int opt = this.menu("Load adventure:", filenames, false);
            this.filename_ = filename = filenames[opt];
        }
        try {
            this.println(Global.join("Loading ", filename));
            new Parser(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (this.dump_) {
            System.err.println(Adventure.getAdv());
        }
        Adventure.getAdv().intro();
    }

    public void log(String s) {
        if (this.logger_ != null) {
            this.logger_.println(s);
        }
    }

    public void loggerStart(String filename) {
        try {
            File file = new File(filename);
            FileWriter fw = new FileWriter(filename, file.exists());
            this.logger_ = new PrintWriter((Writer)fw, true);
            this.logger_.println(Global.join(">>>LOG started ", new Date().toString()));
        }
        catch (IOException e) {
            System.err.println("Unable to open logfile " + filename + ": " + e);
            this.logger_ = null;
        }
    }

    public void loggerStop() {
        if (this.logger_ != null) {
            this.logger_.println(Global.join(">>>LOG ended ", new Date().toString()));
            this.logger_.close();
            this.logger_ = null;
        }
    }

    public int menu(String prompt, String[] options, boolean cancel) {
        char c;
        this.println(prompt);
        if (cancel) {
            this.println("0) (cancel)");
        }
        int len = options.length;
        for (int i = 0; i < len; ++i) {
            char c2 = (char)(97 + i);
            this.println(Global.join(Global.toString(c2), ") ", options[i]));
        }
        while (true) {
            String s;
            if ((s = this.input("? ")) == null || s.length() != 1) {
                continue;
            }
            c = s.charAt(0);
            if (cancel && c == '0') {
                return -1;
            }
            if (c >= 'a' && c <= 'z') break;
        }
        return c - 97;
    }

    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a.startsWith("-")) {
                if ((i = this.parseOption(args, i, a)) >= 0) continue;
                this.usage();
                continue;
            }
            if (this.filename_ == null) {
                this.filename_ = a;
                continue;
            }
            this.usage();
        }
    }

    public int parseOption(String[] args, int i, String a) {
        if (i != 0 || !a.equals("-text")) {
            if (a.equals("-dump")) {
                this.dump_ = true;
            } else if (a.equals("-debug")) {
                this.debug_ = true;
            } else if (a.equals("-log") && i < args.length - 1) {
                this.loggerStart(args[++i]);
            } else if (a.equals("-cols")) {
                try {
                    this.setColumns(Integer.parseInt(args[++i]));
                }
                catch (NumberFormatException e) {
                    System.err.println("Columns must be a number, not '" + args[i] + "'");
                    return -1;
                }
            } else if (a.equals("-rows")) {
                try {
                    this.setRows(Integer.parseInt(args[++i]));
                }
                catch (NumberFormatException e) {
                    System.err.println("Screen rows must be a number, not '" + args[i] + "'");
                    return -1;
                }
            } else {
                return -1;
            }
        }
        return i;
    }

    public final void println(String text) {
        int columns = this.getColumns();
        if (text.length() == 0) {
            this.print("\n");
        } else {
            StringTokenizer st = new StringTokenizer(text, " \t\n", true);
            boolean line = false;
            StringBuffer sb = new StringBuffer(columns);
            block5: while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                char c = tok.charAt(0);
                switch (c) {
                    case ' ': {
                        if (sb.length() >= columns - 1) {
                            sb.append('\n');
                            this.print(sb.substring(0));
                            sb.setLength(0);
                            continue block5;
                        }
                        sb.append(c);
                        continue block5;
                    }
                    case '\t': {
                        int sp = sb.length() % 8;
                        if (sp == 0) {
                            sp = 8;
                        }
                        while (sp > 0) {
                            sb.append(' ');
                            --sp;
                        }
                        continue block5;
                    }
                    case '\n': {
                        sb.append('\n');
                        this.print(sb.substring(0));
                        sb.setLength(0);
                        continue block5;
                    }
                }
                if (sb.length() + tok.length() >= columns) {
                    sb.append('\n');
                    this.print(sb.substring(0));
                    sb.setLength(0);
                }
                sb.append(tok);
            }
            if (sb.length() > 0) {
                sb.append('\n');
                this.print(sb.substring(0));
            }
            this.scrollDown();
        }
        if (this.logger_ != null) {
            this.logger_.println(text);
        }
    }

    public void restore(String filename) {
        block4: {
            try {
                ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(filename)));
                this.filename_ = in.readUTF();
                Adventure adv = (Adventure)in.readObject();
                adv.setEnvironment(this);
                Adventure.setAdv(adv);
                in.close();
                this.println(Global.join("Restored from ", filename, "."));
                adv.doLook("", "");
            }
            catch (IOException e) {
                this.println("Restore from " + filename + " failed: " + e);
                if (this.getDebug()) {
                    e.printStackTrace();
                }
            }
            catch (ClassNotFoundException e) {
                this.println("Restore from " + filename + " failed: " + e);
                if (!this.getDebug()) break block4;
                e.printStackTrace();
            }
        }
    }

    public void run() {
        String line = "";
        while (this.isPlaying() && line != null) {
            line = this.input("> ");
            if (line == null || line.length() <= 0) continue;
            try {
                Adventure.getAdv().doCommand(line);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void save(String filename) {
        block2: {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(filename)));
                out.writeUTF(this.filename_);
                out.writeObject(Adventure.getAdv());
                out.close();
                this.println(Global.join("Saved to ", filename, "."));
            }
            catch (IOException e) {
                this.println("Save to " + filename + " failed: " + e);
                if (!this.getDebug()) break block2;
                e.printStackTrace();
            }
        }
    }

    public void scrollDown() {
    }

    public void setColumns(int columns) {
        this.columns_ = columns;
    }

    public void setRows(int rows) {
        this.rows_ = rows;
    }

    public void setDebug(boolean d) {
        this.debug_ = d;
    }

    public void setPlaying(boolean p) {
        this.playing_ = p;
    }

    public void start() {
        this.run();
    }

    public void usage() {
        System.err.println("Usage: Aiee [-text] [OPTION]... ADVENTUREFILE");
        System.err.println("OPTION:");
        this.usageOptions();
        System.exit(1);
    }

    public void usageOptions() {
        System.err.println("  -text         Run in text-only console mode");
        System.err.println("  -dump         Dump database to stderr");
        System.err.println("  -debug        Display a bunch of debugging info");
        System.err.println("  -log LOGFILE  Log to a given filename");
        System.err.println("  -cols N       Display with N columns");
        System.err.println("  -rows N       Display with N rows");
    }

    public boolean yesno(String prompt) {
        while (true) {
            String s;
            if ((s = this.input(Global.join(prompt, " (y/n) "))).length() == 0) {
                continue;
            }
            char c = Character.toLowerCase(s.charAt(0));
            if (c == 'y') {
                return true;
            }
            if (c == 'n') break;
        }
        return false;
    }

    public abstract String input(String var1);

    public abstract Icon loadImage(String var1);

    public abstract AudioClip loadSound(String var1);

    public abstract void playSound(String var1, int var2);

    public abstract void print(String var1);

    public abstract void quit();

    public abstract void showImage(String var1);

    public abstract void title(String var1);
}

