/* allint.h -- TUU -- saves my sanity and prototyped header*/

#include <stdio.h> /* for FILE */

#pragma lint -1   /* TUU */
#define MyInt long  /* was int -- works as int! */
#define UNIX      /* TUU */

/* from advmsg.c */
void msg_init(FILE *fd,MyInt base);
void msg_open(unsigned MyInt msg);
MyInt msg_byte(void);
MyInt decode(int ch);
void get_block(unsigned MyInt blk);

/* from advtrm.c */
void trm_init(MyInt rows,MyInt cols,char *name);
void trm_done(void);
char *trm_get(char *line);
void trm_str(char *str);
void trm_xstr(char *str);
void trm_chr(int ch);
void trm_word(void);
void trm_eol(void);
void trm_wait(void);
char *trm_line(char *line);
int getchr(void);  /* was myint getchr */
void putchr(int ch); /* was myInt ch */
void trm_shutdown(char *textport);  /* ONLY used when CONSOLE is defined */


/* from advprs.c */
MyInt parse(void);
MyInt next(void);
MyInt fill_action_array(void);
MyInt parse1(void);
MyInt getverb(void);
MyInt getnoun(void);
MyInt get_line(void);
MyInt skip_spaces(void);
void show_noun(MyInt n);
MyInt get_word(void);
MyInt spacep(int ch);
void parse_error(void);

/* from advdbs.c */
void db_init(char *name);
MyInt db_save(void); /* took out char *name TUU */
MyInt db_restore(void); /* took out char *name TUU */
MyInt db_restart(void);
void complement(char *adr,MyInt len);
MyInt findword(char *word);
MyInt wtype(MyInt wrd);
MyInt match(MyInt obj,MyInt noun,MyInt *adjs);
MyInt checkverb(MyInt *verbs);
MyInt findaction(MyInt *verbs,MyInt preposition,MyInt flag);
MyInt getp(MyInt obj,MyInt prop);
MyInt setp(MyInt obj,MyInt prop,MyInt val);
MyInt findprop(MyInt obj,MyInt prop);
MyInt hasnoun(MyInt obj,MyInt noun);
MyInt hasadjective(MyInt obj,MyInt adjective);
MyInt hasverb(MyInt act,MyInt *verbs);
MyInt haspreposition(MyInt act,MyInt preposition);
MyInt inlist(MyInt link,MyInt word);
MyInt getofield(MyInt obj,MyInt off);
MyInt putofield(MyInt obj,MyInt off,MyInt val);
MyInt getafield(MyInt act,MyInt off);
MyInt getabyte(MyInt act,MyInt off);
MyInt getoloc(MyInt n);
MyInt getaloc(MyInt n);
MyInt getvalue(MyInt n);
MyInt setvalue(MyInt n,MyInt v);
MyInt getwloc(MyInt n);
MyInt getword(MyInt n);
MyInt putword(MyInt n,MyInt w);
MyInt getbyte(MyInt n);
MyInt getcbyte(MyInt n);
MyInt getcword(MyInt n);
MyInt getdword(char *p);
MyInt putdword(char *p,MyInt w);
void nerror(char *fmt,MyInt n);

/* from advint.c */
void play(void);
void error(char *msg);
int single(void);

/* from advjunk.c */
#ifndef UNIX
MyInt rand(void);
void srand(long n);
#endif
int getch(void);
void waitch(void);
void putch(int ch,FILE *fp);
MyInt advsave(char *hdr,MyInt hlen,char *save,MyInt slen);
MyInt advrestore(char *hdr,MyInt hlen,char *save,MyInt slen);

/* from advexe.c */
MyInt execute(MyInt code);
void exe_one(void);
MyInt getboperand(void);
MyInt getwoperand(void);
void print(MyInt msg);
int vowel(MyInt msg);
void pnumber(MyInt n);
MyInt getrand(MyInt n);
void setrand(long n);

/* from advgfx.c */
void display_picture(void);
