/* advdbs.h - adventure database definitions */
/*
	Copyright (c) 1986, by David Michael Betz
	All rights reserved
*/

/* useful constants */
#define T	-1L
#define NIL	0L
#define WRDSIZE	(MyInt)6

/* data structure version number */
#define VERSION		((int)102)

/* file header offsets */
#define HDR_LENGTH	((MyInt)0) /* length of header in bytes */
#define HDR_MAGIC	((MyInt)2) /* magic information (6 bytes) */
#define HDR_VERSION	((MyInt)8)	/* data structure version number */	
#define HDR_ANAME	((MyInt)10)	/* adventure name (18 bytes) */
#define HDR_AVERSION	((MyInt)28)	/* adventure version number */
#define HDR_WTABLE	((MyInt)30)	/* offset to word table */
#define HDR_WTYPES	((MyInt)32)	/* offset to word type table */
#define HDR_OTABLE	((MyInt)34)	/* offset to object table */
#define HDR_ATABLE	((MyInt)36)	/* offset to action table */
#define HDR_VTABLE	((MyInt)38)	/* offset to variable table */
#define HDR_DBASE	((MyInt)40)	/* offset to base of data space */
#define HDR_CBASE	((MyInt)42)	/* offset to base of code space */
#define HDR_DATBLK	((MyInt)44)	/* first data block */
#define HDR_MSGBLK	((MyInt)46)	/* first message text block */
#define HDR_INIT	((MyInt)48)	/* initialization code */
#define HDR_UPDATE	((MyInt)50)	/* update code */
#define HDR_BEFORE	((MyInt)52)	/* code to execute before verb handler */
#define HDR_AFTER	((MyInt)54)	/* code to execute after verb handler */
#define HDR_ERROR	((MyInt)56)	/* error handler code */
#define HDR_SAVE	((MyInt)58)	/* save area offset */
#define HDR_SLEN	((MyInt)60)	/* save area length */
#define HDR_SIZE	((MyInt)62)	/* size of header */

/* word types */
#define WT_UNKNOWN	((MyInt)0)
#define WT_VERB		((MyInt)1)
#define WT_NOUN		((MyInt)2)
#define WT_ADJECTIVE	((MyInt)3)
#define WT_PREPOSITION	((MyInt)4)
#define WT_CONJUNCTION	((MyInt)5)
#define WT_ARTICLE	((MyInt)6)

/* object fields */
#define O_CLASS		((MyInt)0)
#define O_NOUNS		((MyInt)2)
#define O_ADJECTIVES	((MyInt)4)
#define O_NPROPERTIES	((MyInt)6)
#define O_PROPERTIES	((MyInt)8)
#define O_SIZE		((MyInt)8)

/* action fields */
#define A_VERBS		((MyInt)0)
#define A_PREPOSITIONS	((MyInt)2)
#define A_FLAG		((MyInt)4)
#define A_MASK		((MyInt)5)
#define A_CODE		((MyInt)6)
#define A_SIZE		((MyInt)8)

/* link fields */
#define L_DATA		((MyInt)0)
#define L_NEXT		((MyInt)2)
#define L_SIZE		((MyInt)4)

/* property flags */
#define P_CLASS		(MyInt)0x8000	/* class property */

/* action flags */
#define A_ACTOR		(MyInt)0x01	/* actor */
#define A_DOBJECT	(MyInt)0x02	/* direct object */
#define A_IOBJECT       (MyInt)0x04	/* indirect object */

/* opcodes */
#define OP_BRT		(MyInt)0x01	/* branch on true */
#define OP_BRF		(MyInt)0x02	/* branch on false */
#define OP_BR		(MyInt)0x03	/* branch unconditionally */
#define OP_T		(MyInt)0x04	/* load top of stack with t */
#define OP_NIL		(MyInt)0x05	/* load top of stack with nil */
#define OP_PUSH		(MyInt)0x06	/* push nil onto stack */
#define OP_NOT		(MyInt)0x07	/* logical negate top of stack */
#define OP_ADD		(MyInt)0x08	/* add two numeric expressions */
#define OP_SUB		(MyInt)0x09	/* subtract two numeric expressions */
#define OP_MUL		(MyInt)0x0A	/* multiply two numeric expressions */
#define OP_DIV		(MyInt)0x0B	/* divide two numeric expressions */
#define OP_REM		(MyInt)0x0C	/* remainder of two numeric expressions */
#define OP_BAND		(MyInt)0x0D	/* bitwise and of two numeric expressions */
#define OP_BOR		(MyInt)0x0E	/* bitwise or of two numeric expressions */
#define OP_BNOT		(MyInt)0x0F	/* bitwise not of two numeric expressions */
#define OP_LT		(MyInt)0x10	/* less than */
#define OP_EQ		(MyInt)0x11	/* equal to */
#define OP_GT		(MyInt)0x12	/* greater than */
#define OP_LIT		(MyInt)0x13	/* load literal */
#define OP_VAR		(MyInt)0x14	/* load a variable value */
#define OP_GETP		(MyInt)0x15	/* get the value of an object property */
#define OP_SETP		(MyInt)0x16	/* set the value of an object property */
#define OP_SET		(MyInt)0x17	/* set the value of a variable */
#define OP_PRINT	(MyInt)0x18	/* print messages */
#define OP_TERPRI	(MyInt)0x19	/* terminate the print line */
#define OP_PNUMBER	(MyInt)0x1A	/* print a number */
#define OP_FINISH	(MyInt)0x1B	/* finish handling this command */
#define OP_CHAIN	(MyInt)0x1C	/* chain to the next handler */
#define OP_ABORT	(MyInt)0x1D	/* abort this command */
#define OP_EXIT		(MyInt)0x1E	/* exit the program */
#define OP_RETURN	(MyInt)0x1F	/* return from interpreter */
#define OP_CALL		(MyInt)0x20	/* call a function */
#define OP_SVAR		(MyInt)0x21	/* MyInt load a variable */
#define OP_SSET		(MyInt)0x22	/* short set a variable */
#define OP_SPLIT	(MyInt)0x23	/* short load a positive literal */
#define OP_SNLIT	(MyInt)0x24	/* short load a negative literal */
#define OP_YORN		(MyInt)0x25	/* yes-or-no predicate */
#define OP_SAVE		(MyInt)0x26	/* save data structures */
#define OP_RESTORE	(MyInt)0x27	/* restore data structures */
#define OP_ARG		(MyInt)0x28	/* load an argument value */
#define OP_ASET		(MyInt)0x29	/* set an argument value */
#define OP_TMP		(MyInt)0x2A	/* load a temporary variable value */
#define OP_TSET		(MyInt)0x2B	/* set a temporary variable */
#define OP_TSPACE	(MyInt)0x2C	/* allocate temporary variable space */
#define OP_CLASS	(MyInt)0x2D	/* get the class of an object */
#define OP_MATCH	(MyInt)0x2E	/* match a noun phrase with an object */
#define OP_PNOUN	(MyInt)0x2F	/* print a noun phrase */
#define OP_RESTART	(MyInt)0x30	/* restart the current game */
#define OP_RAND		(MyInt)0x31	/* generate a random number */
#define OP_RNDMIZE	(MyInt)0x32	/* seed the random number generator */
#define OP_SEND		(MyInt)0x33	/* send a message to an object */
#define OP_VOWEL	(MyInt)0x34	/* check for vowel beginning string */

#define OP_XVAR		(MyInt)0x40	/* extra MyInt load a variable */
#define OP_XSET		(MyInt)0x60	/* extra short set a variable */
#define OP_XPLIT	(MyInt)0x80	/* extra short load a positive literal */
#define OP_XNLIT	(MyInt)0xC0	/* extra short load a negative literal */

/* builtin variables */
#define V_ACTOR		(MyInt)1	/* actor noun phrase number */
#define V_ACTION	(MyInt)2	/* action from parse */
#define V_DOBJECT	(MyInt)3	/* first direct object noun phrase number */
#define V_NDOBJECTS	(MyInt)4	/* number of direct object noun phrases */
#define V_IOBJECT	(MyInt)5	/* indirect object noun phrase number */
#define V_OCOUNT	(MyInt)6	/* total object count */
