/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// FlagTable.h: interface for the CFlagTable class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FLAGTABLE_H__94E53306_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
#define AFX_FLAGTABLE_H__94E53306_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "afx.h"

///////////////////////////////
//System Flags  Definitions

#ifndef __SYS_FLAGS
#define __SYS_FLAGS

#define FL_DARK			0	//Is It DArk
#define FL_VERB			33	//Current Verb
#define FL_NOUN1		34	//Current Noun1
#define FL_ADJECTIVE1	35	//Curretn Adjective
#define FL_ADVERB		36	//Current Adverb
#define FL_LOCATION		38	//Current Location
#define FL_PREP			43	//Preposition
#define FL_NOUN2		44  //Noun2
#define FL_ADJECTIVE2	45	//Adjective2 
#define FL_MODE			40	//Screen IO Mode
#define FL_CURRENT_OBJECT 51 //current object

#endif
////////////////////////////////

class CFlagTable : public CObject 
{

	DECLARE_SERIAL( CFlagTable )

public:
	void DoAutoDecs( void );
	void DelAutoDec( int FlagNo );
	void AddAutoDec( int FlagNo );
	void IncFlag( int FlagNo );
	void DecFlag(int FlagNo);
	void SetFlag( int Flag, int Value );
	int GetFlag( int Flag );
	CFlagTable();
	virtual ~CFlagTable();
	int WeightCarried;
	int ObjectsCarried;
	void Reset( void );
  
	virtual void Serialize( CArchive &ar );

private:
	

	CArray<int, int> FlagList;
	int AutoDecFlags[100];

};

#endif // !defined(AFX_FLAGTABLE_H__94E53306_BCE0_11D1_AD07_00805F36B9D5__INCLUDED_)
