{ The Mapper - By Marc Mason 7/18/90
  This program graphically (with character graphics) presents a map of an
  adventure game.  The user inputs descriptions of rooms and the directions
  to other rooms and a map is constructed.  See readme.txt and mapper.hlp
  for more.

  2/20/94 - Change cls to work on a PC.

  7/19/90 - Original version.  Written in CPM on a Commodore 128.

}

{ Compile to a COM file with minimum code segment set to 370, data segment
  set to 40 and minimum free dynamic memory set to 2400. }

program mapper(infile,outfile);

const ESC      = 27;
      STARTROW = 32;
      STARTCOL = 32;
      N        = 0;
      NW       = 1;
      W        = 2;
      SW       = 3;
      S        = 4;
      SE       = 5;
      E        = 6;
      NE       = 7;
      U        = 8;
      D        = 9;
      DONT_KNOW= 10;
      MIDDLE   = 11;
      MAXROOMS = 200;
      INPUT_ROW = 12;
      INPUT_COL = 20;
      ROOM_COL  = 2;
      ROOM_ROW  = 1;
      COMM_ROW  = 2;
      COMM_COL  = 71;
      MISC_ROW  = 12;
      MISC_COL  = 53;
      ERROR_ROW = 24;
      ERROR_COL = 53;
      ROOM_NUM_COL = 9;
      MID_ROW   = 50;
      MID_COL   = 50;
      MID_LEVEL = 50;

type line_str = string[12];
     desc_str = string[36];
     room_number = 0..MAXROOMS;
     room_pointer = ^room;
     room = record
          desc : desc_str;
          row, col, level, room_num : integer;
          dir : array[N..D] of room_number;
     end;
     indextype = 1..MAXROOMS;
     que = record
              elements : array[indextype] of room_pointer;
              front, rear : indextype;
           end;

var first_room, current_room : room_pointer;
    old_room : array[N..D] of boolean;
    row, rowd : array[N..MIDDLE] of integer;   { Rows and columns for rooms and }
    col, cold : array[N..MIDDLE] of integer;   { directions }
    num_rooms : integer;
    finish : boolean;
    file_name : line_str;
    rooms : array[room_number] of room_pointer;


procedure draw_room(x,y : integer);

begin
     gotoxy(y, x);
     write('+------------+');
     gotoxy(y, x + 1);
     write('|            |');
     gotoxy(y, x + 2);
     write('|            |');
     gotoxy(y, x + 3);
     write('|            |');
     gotoxy(y, x + 4);
     write('+------------+');
end;


function get_dir(a_room : room; dir : integer) : room_pointer;

begin
   get_dir := rooms[a_room.dir[dir]]
end; {get_dir}


procedure init;

var count : integer;

begin
   gotoxy(ROOM_COL, ROOM_ROW);
   write('Room #');
   gotoxy(COMM_COL, COMM_ROW);
   write('Commands');
   gotoxy(COMM_COL - 3, COMM_ROW + 1);
   write('CR - nxt room');
   gotoxy(COMM_COL - 3, COMM_ROW + 2);
   write('/ - new room');
   gotoxy(COMM_COL - 3, COMM_ROW + 3);
   write('. - move');
   gotoxy(COMM_COL - 3, COMM_ROW + 4);
   write(', - inp. desc');
   gotoxy(COMM_COL - 3, COMM_ROW + 5);
   write('- - del. dir.');
   gotoxy(COMM_COL - 3, COMM_ROW + 6);
   write('+ - one way');
   gotoxy(COMM_COL - 3, COMM_ROW + 7);
   write('i - input map');
   gotoxy(COMM_COL - 3, COMM_ROW + 8);
   write('o - out. map');
   gotoxy(COMM_COL - 3, COMM_ROW + 9);
   write('p - print map');
   for count := N to D do
       old_room[count] := false;
   new(rooms[1]);
   rooms[1]^.desc := '';
   rooms[1]^.room_num := 1;
   rooms[1]^.row := MID_ROW;
   rooms[1]^.col := MID_COL;
   rooms[1]^.level := MID_LEVEL;
   rooms[0]^.row := -1;
   for count := N to D do begin
       rooms[1]^.dir[count] := 0;
       rooms[0]^.dir[count] := 0
   end;
   current_room := rooms[1];
   file_name := '';
   num_rooms := 1;
   rowd[N] := 7;
   cold[N] := 23;
   rowd[NE] := 10;
   cold[NE] := 33;
   rowd[E] := 13;
   cold[E] := 32;
   rowd[SE] := 16;
   cold[SE] := 33;
   rowd[S] := 15;
   cold[S] := 23;
   rowd[SW] := 18;
   cold[SW] := 16;
   rowd[W] := 13;
   cold[W] := 15;
   rowd[NW] := 8;
   cold[NW] := 16;
   rowd[U] := 9;
   cold[U] := 28;
   rowd[D] := 15;
   cold[D] := 28;
   row[N] := 3;
   col[N] := 19;
   row[NE] := 3;
   col[NE] := 36;
   row[E] := 11;
   col[E] := 36;
   row[SE] := 19;
   col[SE] := 36;
   row[S] := 19;
   col[S] := 19;
   row[SW] := 19;
   col[SW] := 2;
   row[W] := 11;
   col[W] := 2;
   row[NW] := 3;
   col[NW] := 2;
   row[U] := 5;
   col[U] := 53;
   row[D] := 17;
   col[D] := 53;
   row[MIDDLE] := 11;
   col[MIDDLE] := 19;
   draw_room(row[MIDDLE], col[MIDDLE])
end;


procedure erase_room(x,y : integer);

begin
     gotoxy(y, x);
     write('              ');
     gotoxy(y, x + 1);
     write('              ');
     gotoxy(y, x + 2);
     write('              ');
     gotoxy(y, x + 3);
     write('              ');
     gotoxy(y, x + 4);
     write('              ');
end;


procedure print_desc1(var desc : desc_str; line_num, row, col : integer;
                      screen : boolean);

var x, y, z : integer;


   function word_to_left(str : desc_str; pos : integer) : integer;

   begin
      while (str[pos] <> ' ') and (pos > 0) do
         pos := pos - 1;
      word_to_left := pos + 1
   end {word_to_left};


   function word_to_right(str : desc_str; pos : integer) : integer;

   begin
      while (pos <= length(str)) and (str[pos] <> ' ') do
         pos := pos + 1;
      word_to_right := pos + 1;
   end {word_to_right};


   procedure print_line(line : line_str; screen : boolean);

   var first : integer;

   begin
      first := (12 - length(line)) div 2 + length(line);
      if screen then
         write(line : first, '' : 12 - first)
      else
         write(lst, line : first, '' : 12 - first)
   end {print_line};


begin {print_desc1}
   if line_num = 1 then begin
      if screen then
         gotoxy(col + 1, row + 1);
      print_line(desc, screen)
   end
   else begin
      x := length(desc) div line_num;
      y := word_to_left(desc, x + 1);
      z := word_to_right(desc, x - 1);
      if x > (y + z) div 2 then
         x := z
      else
         x := y;
      if screen then
         gotoxy(col + 1, row + 1);
      print_line(copy(desc, 1, x - 2), screen);
      if line_num > 1 then
         desc := copy(desc, x, length(desc) - x + 1)
   end
end {print_desc1};


procedure print_desc(desc : desc_str; line_num, row, col : integer);

var save_desc : desc_str;
    loop : integer;

begin
   for loop := 1 to 3 do
      print_desc1(desc, 4 - loop, row + loop - 1, col, TRUE)
end; {print_desc}


procedure erase_words;

var count : integer;

begin
   for count := 1 to 3 do begin
      gotoxy(col[MIDDLE] + 1, row[MIDDLE] + count);
      write(' ' : 12)
   end
end; {erase_words}


procedure print_screen;

var count, loop : integer;
    save_desc : desc_str;


   procedure draw_dir(dir : integer);

   begin
      with current_room^ do
         begin
            gotoxy(cold[count], rowd[count]);
            if current_room^.dir[count] <> 0 then
            case count of
               NW, SE : write('\', chr(10), '\', chr(10), '\');
               NE, SW : write('/', chr(11), '/', chr(11), '/');
               E, W   : write('+---+');
               N, S   : write('+', chr(10), chr(8), '|', chr(10), chr(8),
                        '|', chr(10), chr(8), '|', chr(10), chr(8), '+');
               U      : begin
                        write('U', chr(10), chr(8), '|', chr(10), chr(8),
                              '+');
                        gotoxy(57,9);
                        write('+', chr(10), chr(8), '|', chr(10), chr(8),
                              'U');
                        end;
               D      : begin
                        write('+', chr(10), chr(8), '|', chr(10), chr(8),
                              'D');
                        gotoxy(57,15);
                        write('D', chr(10), chr(8), '|', chr(10), chr(8),
                              '+');
                        end
            end {case}
         end
   end; {draw_dir}


   procedure erase_dir(dir : integer);

   begin
      with current_room^ do
         begin
            gotoxy(cold[count], rowd[count]);
            case count of
               NW, SE : write(' ', chr(10), ' ', chr(10), ' ');
               NE, SW : write(' ', chr(11), ' ', chr(11), ' ');
               E      : write('|   ');
               W      : write('    |');
               S      : write('-', chr(10), chr(8), ' ', chr(10), chr(8),
                        ' ', chr(10), chr(8), ' ');
               N      : write(chr(10), ' ', chr(10), chr(8),
                        ' ', chr(10), chr(8), ' ', chr(10), chr(8), '-');
               U      : begin
                        write(' ', chr(10), chr(8), ' ', chr(10), chr(8),
                              '-');
                        gotoxy(57,10);
                        write(' ', chr(10), chr(8),
                              ' ');
                        end;
               D      : begin
                        write('-', chr(10), chr(8), ' ', chr(10), chr(8),
                              ' ');
                        gotoxy(57,15);
                        write(' ', chr(10), chr(8), ' ');
                        end
            end
         end
   end; {draw_dir}


begin {print_screen}
     gotoxy(ROOM_NUM_COL, ROOM_ROW);
     write(current_room^.room_num : 3, '   Row : ', current_room^.row : 2,
     ' Col : ', current_room^.col : 2, ' Level : ', current_room^.level : 2,
     '             ');
     for count := N to D do
        if current_room^.dir[count] <> 0 then
           begin
              if not old_room[count] then begin
                 draw_room(row[count], col[count]);
                 draw_dir(count);
                 old_room[count] := true
              end;
              print_desc(rooms[current_room^.dir[count]]^.desc, 3, row[count],
                                                         col[count])
           end
        else if old_room[count] then begin
                erase_room(row[count], col[count]);
                erase_dir(count);
                old_room[count] := false
             end;
     if current_room^.desc <> '' then
        print_desc(current_room^.desc, 3, row[MIDDLE], col[MIDDLE])
     else erase_words
end; {print_screen}


procedure first_line(map_room : room);

begin
{writeln(' 1 row - ', map_room.row, ' col - ', map_room.col, ' level - ', map_room.level);
 }  if map_room.row = -1 then
      write(lst, '' : 17)
   else begin
      write(lst, '+---');
      if map_room.dir[N] <> 0 then
         write(lst, '+')
      else
         write(lst, '-');
      write(lst, '----');
      if map_room.dir[U] <> 0 then
         write(lst, '+')
      else
         write(lst, '-');
      write(lst, '---+   ')
   end
end; {first_line}


procedure second_line(map_room : room; var desc : desc_str);

begin
   if map_room.row = -1 then
      write(lst, '' : 17)
   else begin
      write(lst, '|');
      desc := map_room.desc;
      print_desc1(desc, 3, 1, 1, FALSE);
      write(lst, '|   ')
   end
end; {second_line}


procedure third_line(map_room : room; var desc : desc_str);

begin
   if map_room.row = -1 then
      write(lst, '' : 17)
   else begin
      if map_room.dir[W] <> 0 then
         write(lst, '+')
      else
         write(lst, '|');
      print_desc1(desc, 2, 1, 1, FALSE);
      if map_room.dir[E] <> 0 then
         write(lst, '+---')
      else
         write(lst, '|   ')
   end
end; {third_line}


procedure fourth_line(map_room : room; desc : desc_str);

begin
   if map_room.row = -1 then
      write(lst, '' : 17)
   else begin
      write(lst, '|');
      print_desc1(desc, 1, 1, 1, FALSE);
      write(lst, '|   ')
   end
end; {fourth_line}


procedure fifth_line(map_room : room);

begin
   if map_room.row = -1 then
      write(lst, '' : 17)
   else begin
      write(lst, '+---');
      if map_room.dir[S] <> 0 then
         write(lst, '+')
      else
         write(lst, '-');
      write(lst, '----');
      if map_room.dir[D] <> 0 then
         write(lst, '+')
      else
         write(lst, '-');
      write(lst, '---+   ')
   end
end; {fifth_line}


procedure sixth_line(map_room, next_room : room);

begin
   if map_room.row = -1 then
      write(lst, '' : 17)
   else begin
      write(lst, '    ');
      if map_room.dir[S] <> 0 then
         write(lst, '|')
      else
         write(lst, ' ');
      write(lst, '    ');
      if map_room.dir[D] <> 0 then
         write(lst, '|')
      else
         write(lst, ' ');
      write(lst, '    ');
      if map_room.dir[SE] <> 0 then
         write(lst, '\')
      else
         write(lst, ' ');
      write(lst, ' ');
      if next_room.dir[SW] <> 0 then
         write(lst, '/')
      else
         write(lst, ' ')
   end
end; {sixth_line}


procedure seventh_line(map_room, next_room : room);

begin
   if map_room.row = -1 then
      write(lst, '' : 17)
   else begin
      write(lst, '    ');
      if map_room.dir[S] <> 0 then
         write(lst, '|')
      else
         write(lst, ' ');
      write(lst, '    ');
      if map_room.dir[D] <> 0 then
         write(lst, '|')
      else
         write(lst, ' ');
      write(lst, '     ');
      if map_room.dir[SE] <> 0 then
         if next_room.dir[SW] <> 0 then
            write(lst, 'X')
         else
            write(lst, '\')
      else
         if next_room.dir[SW] <> 0 then
            write(lst, '/')
         else
            write(lst, ' ');
      write(lst, ' ')
   end
end; {seventh_line}


procedure eighth_line(map_room, next_room : room);

begin
   if map_room.row = -1 then
      write(lst, '' : 17)
   else begin
      write(lst, '    ');
      if map_room.dir[S] <> 0 then
         write(lst, '|')
      else
         write(lst, ' ');
      write(lst, '    ');
      if map_room.dir[D] <> 0 then
         write(lst, '|')
      else
         write(lst, ' ');
      write(lst, '    ');
      if next_room.dir[SW] <> 0 then
            write(lst, '/')
         else
            write(lst, ' ');
      write(lst, ' ');
      if map_room.dir[SE] <> 0 then
         write(lst, '\')
      else
         write(lst, ' ');
   end
end; {eighth_line}


function low_level : integer;

var count, level : integer;

begin
   level := 100;
   for count := 1 to num_rooms do
      if (rooms[count]^.level < level) and (rooms[count]^.level <> -1) then
         level := rooms[count]^.level;
   low_level := level
end; {low_level}


function exist_lev(level : integer) : boolean;

var count : integer;

begin
   count := 1;
   while (rooms[count]^.level <> level) and (count <= num_rooms) do
      count := count + 1;
   exist_lev := count <= num_rooms
end; {exist_lev}


function exist_row(row, col, level : integer) : boolean;

var count : integer;

begin
   count := 0;
   repeat
      count := count + 1
   until ((rooms[count]^.row = row) and (rooms[count]^.col >= col) and
         (rooms[count]^.col < col + 9) and (rooms[count]^.level = level)) or
         (count > num_rooms);
   exist_row := count <= num_rooms
end; {exist_row}


function low_row_col(var row, col : integer; level : integer) : boolean;

var save_col, count : integer;

begin
   save_col := col;
   row := 100;
   col := 100;
{   if col = 100 then
      for count := 1 to num_rooms do
         if rooms[count]^.level = level then begin
            if rooms[count]^.row < row then
               row := rooms[count]^.row;
            if rooms[count]^.col < col then
               col := rooms[count]^.col
         end
   else
 }     for count := 1 to num_rooms do
         if (rooms[count]^.level = level) and (rooms[count]^.col >= save_col)
                        then begin
            if rooms[count]^.row < row then
               row := rooms[count]^.row;
            if rooms[count]^.col < col then
               col := rooms[count]^.col
         end;
{writeln('in func, row - ', row, ' col - ', col, ' level - ', level);
 }  low_row_col := row <> 100
end; {low_row_col}


function find_r_c_l(row, col, level : integer) : integer;

var count : integer;

begin
   count := 1;
   while not((rooms[count]^.row = row) and (rooms[count]^.col = col) and
         (rooms[count]^.level = level)) and (count <= num_rooms) do
      count := count + 1;
   if count <= num_rooms then
      find_r_c_l := count
   else
      find_r_c_l := 0
end; {find_r_c_l}


procedure print_map;

const
    ROW_LENGTH = 8;
    R_L = 9;

var map_row : array[FALSE..TRUE, 0..R_L] of integer;
    count, row, col, level, room_num : integer;
    row_num : boolean;
    desc : array[1..ROW_LENGTH] of desc_str;

begin {print_map}
{writeln('in print map');
 }  row_num := FALSE;
   for count := 0 to ROW_LENGTH + 1 do begin
      map_row[TRUE, count] := 0;
      map_row[FALSE, count] := 0
   end;
   level := low_level;
   write(lst, chr(15), chr(27), '0');
   while exist_lev(level) do begin {level}
      col := 0;
      while low_row_col(row, col, level) do begin {page}
{writeln('row - ', row, ' col - ', col, ' level - ', level);
 }        while exist_row(row, col, level) do begin {row}
            for room_num := 1 to ROW_LENGTH do begin {room}
               if rooms[map_row[row_num, room_num - 1]]^.dir[E] <> 0 then
                  map_row[row_num, room_num] := rooms[map_row[row_num, room_num
                                                - 1]]^.dir[E]
               else
                  if rooms[map_row[not(row_num), room_num - 1]]^.dir[SE] <> 0
                                                  then
                     map_row[row_num, room_num] := rooms[map_row[not(row_num),
                                       room_num - 1]]^.dir[SE]
               else
                  if rooms[map_row[not(row_num), room_num]]^.dir[S] <> 0
                                                  then
                     map_row[row_num, room_num] := rooms[map_row[not(row_num),
                                       room_num]]^.dir[S]
               else
                  if rooms[map_row[not(row_num), room_num + 1]]^.dir[SW] <> 0
                                                  then
                     map_row[row_num, room_num] := rooms[map_row[not(row_num),
                                       room_num + 1]]^.dir[SW]
               else
                  map_row[row_num, room_num] := find_r_c_l(row, col, level);
               desc[room_num] := rooms[map_row[row_num, room_num]]^.desc;
{writeln('room num - ', map_row[row_num, room_num]);
 }              first_line(rooms[map_row[row_num, room_num]]^);
               col := col + 1
            end;
            writeln(lst);
            for room_num := 1 to ROW_LENGTH do
               second_line(rooms[map_row[row_num, room_num]]^, desc[room_num]);
            writeln(lst);
            for room_num := 1 to ROW_LENGTH do
               third_line(rooms[map_row[row_num, room_num]]^, desc[room_num]);
            writeln(lst);
            for room_num := 1 to ROW_LENGTH do
               fourth_line(rooms[map_row[row_num, room_num]]^, desc[room_num]);
            writeln(lst);
            for room_num := 1 to ROW_LENGTH do
               fifth_line(rooms[map_row[row_num, room_num]]^);
            writeln(lst);
            for room_num := 1 to ROW_LENGTH do
               sixth_line(rooms[map_row[row_num, room_num]]^,
                          rooms[map_row[row_num, room_num + 1]]^);
            writeln(lst);
            for room_num := 1 to ROW_LENGTH do
               seventh_line(rooms[map_row[row_num, room_num]]^,
                            rooms[map_row[row_num, room_num + 1]]^);
            writeln(lst);
            for room_num := 1 to ROW_LENGTH do
               eighth_line(rooms[map_row[row_num, room_num]]^,
                           rooms[map_row[row_num, room_num + 1]]^);
            writeln(lst);
            row := row + 1;
            col := col - 8;
            row_num := not(row_num)
         end;
         col := col + 8
      end;
      level := level + 1
   end
end; {print_map}


{$I input.inc}


begin
     cls;
     init;
     finish := false;
     repeat
        print_screen;
        accept_input
     until finish
end.
