
#ifndef h_x11lib_h
#define h_x11lib_h

#include <X11/Xlib.h>                        /* for XWindows */
#include <X11/Xutil.h>                       /* for XWindows */
#include <X11/Xos.h>                         /* for XWindows */
#include <X11/cursorfont.h>                  /* for XWindows */
#include <X11/keysym.h>                      /* for XWindows */
#include <X11/keysymdef.h>                   /* for XWindows */
#include <X11/Xatom.h>                       /* for XWindows */

#define MAXFONTS            32
#define MAXPIXELS          256               /* size of pixel buffer */
#define MAXVECTORS          64               /* size of vector buffer */

/* interface declarations
 */

/* library control */
int init_graphics_engine ( void );           /* connect to the XServer */
int open_graphics_engine ( char * );         /* create/open top level window */
int shutdown_graphics_engine ( void );       /* release resources */

/* top level window control */
void flush_display ( void );                 /* commit all operations */
int set_palette_entry ( int entry, int red, int green, int blue );
int query_screen_width ( void );
int query_screen_height ( void );
void fill_region ( int, int, int, int, int );

/* creation and maintenance of graphic contexts */
GC X11MakeDefaultGC ( void );
GC X11MakeGC ( Display *, Drawable, unsigned long, unsigned long );
void X11SetGC ( Display *, GC, unsigned long, unsigned long );

/* image control */
Pixmap create_pixmap ( void );
int set_target_pixmap ( Pixmap pic );
int realize_pixmap ( int, int );
Pixmap query_default_pixmap ( void );

/* vector control */
void set_vector_draw_colour ( int entry );
void begin_vector_draw ( void );
void draw_pending_vectors ( void );
void draw_vector ( int fromx, int fromy, int tox, int toy );
void end_vector_draw ( void );

/* pixel control */
void set_pixel_draw_colour ( int entry );
void begin_pixel_draw ( void );
void draw_pending_pixels ( void );
void draw_pixel ( int fromx, int fromy );
void end_pixel_draw ( void );

/* text control */
void begin_text_draw ( void );
int draw_text ( int gcentry, int x, int y, char *buffer );
void end_text_draw ( void );

/* loading and handling fonts */
int retrieve_font ( int index, char *name );
int set_font ( int gcentry, int fontindex );
int query_font_height ( int fontentry );
int query_font_width ( int fontentry, char *buffer );

/* keyboard control */
void init_keyboard_handler ( void );
void restore_keyboard_handler ( void );

/* signal handling, for keyboard and other periodic events */
void poll_events ( void );
void handleUnixVirtualAlarm ( int sigtype );
void X11ResetVirtualAlarm ( void );
inline void X11UninstallVirtualAlarm ( void );
inline void X11InstallVirtualAlarm ( void );
void handleUnixSigINT ( int sig );

extern void (*handleExpose)( void );               /* user definable */
extern void (*handleKeyPress)( char, KeySym );     /* user definable */
extern void (*handleKeyRelease)( char, KeySym );   /* user definable */

#endif
