//
//  A T2 test game: 
//			a banner that changes alignment every turn
//

#include <adv.t>
#include <std.t>

startroom: room
   sdesc = "XTads T2 banner test"
   ldesc = "Should show a banner that changes alignment every turn"
   turnCount = 0
   alignments = ['top', 'right', 'bottom', 'left']
   sizeAttrs = ['height', 'width', 'height', 'width']
	statusLine =
		{
		local size = 40;
		local cycleCount;
		local align;
		local sizeAttr;
		
		turnCount += 1;
		cycleCount := ((turnCount - 1) % 4) + 1;
		align := alignments[cycleCount];
		sizeAttr := sizeAttrs[cycleCount];
		
		"<banner id=custStatusLine align=<<align>> <<sizeAttr>>=<<size>> border>
			banner text <<turnCount>>, align=<<align>>, <<sizeAttr>>=<<size>>
		</banner>";
		}
;

replace commonInit: function
{
    // turn on html mode
    "\H+";
}
