#include <tads.h>

/*
 * An XTads test game.
 * Focus is on sizes reported in grid banner info.
 */

main(args)
{
	local b0 = nil;
	local b1;
	local b2;
    
    "A banner test game for XTads.";

    //------------

    "\bb1 - grid banner below and 50% of main area:";
    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleBorder);
    bannerSetScreenColor(b1, ColorWhite);
	 bannerSay(b1, 'b1\n');
    inputKey();

    "\bb2 - grid banner right of and 50% of (remaining) main area:\b";
    b2 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignRight,
                       50, BannerSizePercent,
                       BannerStyleBorder);
    bannerSetScreenColor(b2, ColorWhite);
	 bannerSay(b2, 'b2\n');
    inputKey();

	 for (local i = 0; i < 10; i++) {
	 	 "------------- 50 0s\b";
		 bannerSay(b1, '00000000000000000000000000000000000000000000000000\n');  // 50 0's
		 bannerSay(b2, '00000000000000000000000000000000000000000000000000\n');
		 showBannerInfo('b1', b1);
		 showBannerInfo('b2', b2);
   	 inputKey();
   	 // manually resize window here...
	 }
    
    //------------
    
    "\bPress another key to exit...\n";
    inputKey();
}

showBannerInfo(winName, win)
{
    local info = bannerGetInfo(win);

    "<<winName>> : align = <<info[1]>>, style = <<toString(info[2], 16)>>,
    rows = <<info[3]>>, columns = <<info[4]>>, pixel height = <<info[5]>>,
    pixel width = <<info[6]>>\b";
}
