#include <tads.h>

/*
 * An XTads test game.
 * Focus is on vertical strut with same orientation as parent banner.
 */
 /* from src docs:
 *
 *   This banner is a horizontal/vertical "strut" for sizing purposes.  This
 *   means that the banner's content size is taken into account when figuring
 *   the content size of its *parent* banner.  
 *   
 *   If the banner has the same
 *   orientation as the parent, its content size is added to its parent's
 *   internal content size to determine the parent's overall content size.
 *
 *   If the banner's orientation is orthogonal to the parent's, then the
 *   parent's overall content size is the larger of the parent's internal
 *   content size and this banner's content size.  
 *
 * from tads.org docs:
 *
 *   BannerStyleHStrut - makes the banner a "horizontal strut" when bannerSizeToContents() is used to set the parent banner's width. 
 *   If the child banner is a vertical banner (i.e., it has left or right alignment), the width of the child's contents 
 *   is added to the width of the parent's contents to determine the overall content width. 
 *   If the child banner is a horizontal banner (top or bottom alignment), bannerSizeToContents() will set the parent's width 
 *   to the larger of the widths of the parent's or child's contents.
 * 
 *   BannerStyleVStrut - makes the banner a "vertical strut" when bannerSizeToContents() is used to set the parent banner's height. 
 *   This has the same effect on height that BannerStyleHStrut has on width. 
 */
//#define OS_BANNER_STYLE_HSTRUT    0x00000080  BannerStyleHStrut
//#define OS_BANNER_STYLE_VSTRUT    0x00000100  BannerStyleVStrut

main(args)
{
	local b0 = nil;
	local b1;
	local b2;
    
    "A banner test game for XTads.";

    //------------

    "\bb1 - text banner below and 50% of main area:";
    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeText, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleBorder);
	 //bannerSetScreenColor(b1, ColorRed);
    //inputKey();

	 bannerSay(b1, '<BODY BGCOLOR=blue>b1 line1\n');
    inputKey();

    "\bb2 - text banner below b1 and 10 lines:";
    b2 = bannerCreate(b1, BannerFirst, nil, BannerTypeText, BannerAlignBottom,
                       10, BannerSizeAbsolute,
                       BannerStyleBorder | BannerStyleVStrut);
	 //bannerSetScreenColor(b2, ColorBlue);
    //inputKey();

	 bannerSay(b2, '<BODY BGCOLOR=red>b2 line1\nb2 line2');
    inputKey();
    
    "\bResize b1 to contents... TODO what's the expected behaviour?";
    bannerSizeToContents(b1);
    
    //------------
    
    "\bPress another key to exit...\n";
    inputKey();
}
