#ifndef HEARTBEAT_T
#define HEARTBEAT_T

  // heartbeat.t, derived in part from Jeff Liang's TADS2 
  // heartbeat code, and absorbing some ideas from chick.t.
  // Provides a common class to handle multiple daemons.
  // 
  // version dated January 26, 2003.
  //
  // This code copyrighted (C) 2003 by Choices, and contributors.
  // This code is licensed under the IF Library License.
  //
  // Permission is hereby granted to use, copy, modify and/or 
  // distribute this package, provided that: 
  // * copyright terms are retained unchanged, whether the package 
  //   is modified or not.
  // * any distribution of this package, whether modified or not, 
  //   includes this notice.
  // * Aggregation of a binary version of this package with a 
  //   binary distribution is always permitted provided that 
  //   the use of this package is embedded; that is, when no 
  //   overt attempt is made to make this package's code 
  //   interfaces visible to the end user of the binary 
  //   distribution. Such use shall not be construed as a 
  //   distribution of this package.
#include <adv3.h>
#include <en_us.h>
  //
  // mixin class to add the heartbeat method.
  //
class HeartBeatable : object
{
  heartBeatOn { return true; }
  localHeartBeat
  {
    //
    // override this method and add unique code here.
    //
    " <<name>> has a heartbeat.";
  }
}
class HeartBeatObject : object
{
  heartBeatList=[]
  setHeartBeat( obj ) 
  {
    if ( obj.isClass() )
     "ERROR - This object has no physical representation. ";
    else heartBeatList.appendUnique( obj );
  }
  clearHeartBeat( obj )
  {
    local v;
    v = heartBeatList.indexOf( obj );
    if ( v != nil )
      heartBeatList = heartBeatList.removeElementAt( v );
  }
  
  hbDaemon
  {
     if ( heartBeatList.length > 0 )
     {
       foreach (local obj in heartBeatList )
       {
          if ( obj.ofKind(excitementObject) )
            obj.excitementDaemon;
          else if ( obj.heartBeatOn )
            obj.localHeartBeat;
       }
     }
  }     
}

#endif
