#charset "us-ascii"

/*

RAP 1.2 Order Copyright (c) by Steve Breslin
(email: versim@hotmail.com)

License:

You can use this material however you want, but if you decide to
publicize anything that uses, #include's or otherwise borrows from
this material, you have to make your improvements publicly available,
and advertise them to the IF community.

That way, you will help keep this up to date for everybody else, and
everybody else will help keep it up to date for you.

You may redistribute this verbatim or in modified form only if you
keep the copyrights and license intact.

Feel encouraged to release your source code along with your game,
though this isn't a requirement.

 * Instructions:
 * 
 * To use this module, just include this file in your project window
 * in workbench, or otherwise include it in your build directives.
 * Also, this module requires the Tads-3 Knowledge module, which is
 * included in the t3RAP archive for your convenience.
 *
 * The purpose of this module is to enable commands given by the PC
 * to NPC's to resolve into RAP-style commands. So, for example, the
 * player can command Bob to retrieve an object from another room, at
 * which time bob.rapAct(rGive, [obj, me]) would be the result.
 *
 * More instructions forthcoming, once the module has completed the
 * development stage.
 */
#include <adv3.h>
#include <en_us.h>

modify Actor

    /* We want the Rapper to be able to respond to commands which
     * involve objects out of conventional scope. We still want to
     * limit the scope to objects which the Rapper knows about. It
     * might be reasonable to further filter this list based on
     * what the PC knows about, but might be better handled by
     * modifying the rObeyOrder method. In any case, we're leaving
     * that question alone for the present.
     *
     * Note that the scopeList() call is only relevant when the NPC
     * is receiving a command from the PC. It is not relevant when
     * the NPC is calculating a RAP action. In other words, this
     * does not serve as a knowledge-checking system for RAP, though
     * such a system may base itself in part on this modification to
     * the scopeList() method. (A robust knowledge-checking system for
     * RAP is soon forthcoming.)
     */
    scopeList() {
        if (ofKind(Rapper))
            return (knownObjs.keysToList +
                    seenObjs.keysToList +
                    inherited());
        return inherited();
    }

    /* By default we simply obey the order, setting up an animation
     * daemon for the Rapper. You may want to override this, to
     * check the goal and parameter before accepting the order.
     */
    rObeyOrder(step, param) {
        rAnimate(step, param);
    }
;

modify Action

    /* We want RAP to handle the fulfillment of the command if the
     * current actor is an NPC RAP actor, and if the verb in question
     * is mapped to an rStep. If RAP is already handling the command
     * (libGlobal.rIsRapping is true), then we process the command as
     * normal. Otherwise, we call gActor.rObeyOrder(), which by default
     * will create an rAnimate daemon to automate the RAP process.
     */
    doActionOnce() {
        if ( rMapAction &&
             gActor.ofKind(Rapper) &&
             (gActor != gPlayerChar) ) {

            /* Were we to allow the normal doActionOnce()
             * processing to handle things if the direct and
             * indirect objects are visible to the current actor,
             * this would mean that an order could have different
             * results based on whether the relevant objects are
             * visible or not. This can be undesirable behavior, so we
             * always have RAP handle commands given to an NPC RAP
             * actor. This ensures consistent behavior.
             */
            if (!libGlobal.rIsRapping) {
                local p = nil;
                if (gIobj && gDobj)
                    p = [gDobj, gIobj];
                else if (gDobj)
                    p = gDobj;
                gActor.rObeyOrder(rMapAction, p);
            }
            else inherited();
        }
        else inherited();
    }
    rMapAction = nil
;

/* Map a few verbs to rSteps, for testing purposes. This is not a
 * complete mapping of verbs to rSteps.
 */
modify PutInAction
    rMapAction = rObjIn
;

modify PutOnAction
    rMapAction = rObjOn
;

modify TakeAction
    rMapAction = rHold
;

modify UnlockAction
    rMapAction = rUnlocked
;

modify UnlockWithAction
    rMapAction = rUnlocked
;

/* need to add LockAction, LockWithAction, etc. */
