#charset "us-ascii"

/*
 *   MegaTADS. Additions and modifications to the extras.t file.
 *
 *   Copyright 2007, Krister Fundin.
 */

#include <adv3.h>

#include "mega.h"

/* ---------------------------------------------------------------------- */
/*
 *   Amend the ComplexContainer class so that we can distinguish properly
 *   between objects which are in, on, under and behind these objects.
 */

#ifdef MEGA_LOCATIONAL_ON

modify ComplexContainer
    containsWithContType(obj, contType)
    {
        /* see which of our subXxx locations the object is in */
        foreach (local sub in [subContainer, subSurface,
                              subUnderside, subRear])
        {
            /* check if the object is in this sub-location */
            if (sub != nil && obj.isIn(sub))
            {
                /* it is, so delegate the call to the sub-location */
                return sub.containsWithContType(obj, contType);
            }
        }

        /*
         *   The object wasn't is any of our sub-locations, so it must be a
         *   direct component of us. Just use the inherited behaviour, which
         *   checks our own contTypes list.
         */
        return inherited(obj, contType);
    }
;

/*
 *   Modify the Underside and RearContainer classes so that they recognize
 *   the appropriate containment types.
 */
modify Underside
    contTypes = [underContType, genericContType]
;

modify RearContainer
    contTypes = [behindContType, genericContType]
;

#endif

/* ---------------------------------------------------------------------- */
/*
 *   Add USE handling to the Key class.
 */

#ifdef MEGA_USE_ON

modify Key
    dobjFor(Use)
    {
        verify() { }
        action()
        {
            askForIobj(UseWith);
        }
    }

    dobjFor(UseWith)
    {
        verify() { verifyIobjLockWith(); }
        preCond() { return preCondIobjLockWith(); }
        remap()
        {
            local lock, action;

            if (gIobj != nil)
            {
                lock = gIobj;
            }
            else
            {
                if (gTentativeIobj.length == 1)
                    lock = gTentativeIobj[1].obj_;
            }

            if (lock != nil)
            {
                if (lock.isLocked)
                    action = UnlockWithAction;
                else
                    action = LockWithAction;
            }
            else
            {
                action = UnlockWithAction;
            }

            return [action, IndirectObject, self];
        }
    }
;

#endif

