#charset "us-ascii"

/* 
 *  Copyright (c) 2004 - 2005 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 London Cabs Library Extension
 *
 *  whistle.t
 *
 *  Defines a Whistle class used to call the london cabs. 
 */

#include <adv3.h>
#include <en_us.h>

class Whistle: Wearable
{
    /* -------------------------------------------------------------------- */
    /*
     *   "Blow" action 
     */
    dobjFor(Blow)
    {
        preCond = [objHeld]
        verify() {}
        action()
        {
            local noise, loc;

            try
            {
                /* create a new sound event for the whistle */
                noise = new WhistleNoise();

                /*
                 *  Trigger notification of the event.
                 *  This may cause us to exit out of the
                 *  try block.
                 */
                noise.triggerEvent(self);

                /* get the whistle's outermost location */
                loc = getOutermostRoom();

                /*
                 *  Check if the location is one we can
                 *  travel to by cab. If so, request a
                 *  cab to the location.
                 */
                if (findDestTravelTopic(loc))
                    londonCabbie.requestCab(loc);

                /* describe the sound of the whistle */
                defaultReport(&okayBlowWhistle);  
            }
            /*
             *  This block is used to catch any exits
             *  from sound event notification and is 
             *  useful in bypassing further whistle 
             *  logic processing.
             */
            catch(ExitActionSignal eaSig)
            {
                exitAction;
            }
        }
    }

    /*
     *  Find the whistle's outermost location.
     */
    getOutermostRoom()
    {
        local loc;

        if (wornBy)
            loc = wornBy;
        else
            loc = self;

        while(loc = loc.location)
        {
            if (loc.ofKind(BasicLocation))
            {
                loc = loc.getOutermostRoom();
                break;
            }
        }

        return loc;
    }

    /*
     *  If our whistle is blown in a location that is
     *  one of our destination travel topics then return
     *  the topic. Otherwise return nil.
     */
    findDestTravelTopic(loc)
    {
        for (local o = firstObj(DestTravelTopic); o != nil;
            o = nextObj(o, DestTravelTopic))
        {
            if (o.dest == loc)
                return o;
        }

        return nil;
    }
}

/*
 *  Defines a Whistle Noise Sound Event that gets 
 *  instantiated each time we blow the whistle.
 */
class WhistleNoise: SoundEvent
;