//
//  XTOutputFormatter.h
//  TadsTerp
//
//  Created by Rune Berg on 09/07/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//
//  Transforms
//		a stream of text|whitespace|tag elements
//	into
//		a stream of XTFormattedOutputElement with attributed strings suitable for game output.
//

#import <Foundation/Foundation.h>
#import "XTOutputFormatterProtocol.h"


@interface XTOutputFormatter : NSObject <XTOutputFormatterProtocol>

@property BOOL htmlMode;

- (void)resetFlags;

- (void)resetForNextCommand;

//TODO ren ...Output
- (NSArray *)formatElement:(id)element;

- (NSAttributedString *)formatInputText:(NSString *)string;

- (NSFont *)getCurrentFontForOutput;

@end
