//
//  XTMouseOverLinkState.m
//  XTads
//
//  Created by Rune Berg on 29/07/2021.
//  Copyright © 2021 Rune Berg. All rights reserved.
//

#import "XTMouseOnLinkState.h"


@implementation XTMouseOnLinkState

@synthesize range = _range;

- (instancetype)initWithRange:(NSRange)range
{
	self = [super init];
	if (self) {
		_range = NSMakeRange(range.location, range.length);
	}
	return self;
}

- (BOOL)isEqual:(id)other
{
	if (other == self) {
		return YES;
	}
	if (other == nil) {
		return NO;
	}
	if (! [other isKindOfClass:[XTMouseOnLinkState class]]) {
		return NO;
	}
	
	XTMouseOnLinkState *castOther = (XTMouseOnLinkState *)other;
	
	if (! NSEqualRanges(self.range, castOther.range)) {
		return NO;
	}
	
	return YES;
}

+ (instancetype)forRange:(NSRange)range
{
	XTMouseOnLinkState *res = [[XTMouseOnLinkState alloc] initWithRange:range];
	return res;
}

@end
