//
//  XTRecolorationHelper.h
//  XTads
//
//  Created by Rune Berg on 13/07/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTTextView.h"
#import "XTOutputTextColorResult.h"
#import "XTHtmlColor.h"
#import "XTFormattingSpecificationForHtmlTag.h"
#import "XTMouseOnLinkState.h"

//NS_ASSUME_NONNULL_BEGIN

@interface XTColorationHelper : NSObject

@property BOOL isForT3;
@property BOOL htmlMode;

@property XTHtmlColor *bodyBackgroundColor;
@property XTHtmlColor *bodyTextColor;
@property XTHtmlColor *bodyInputColor;
@property XTHtmlColor *bodyLinkColor;
@property XTHtmlColor *bodyLinkHoverColor;
@property XTHtmlColor *bodyLinkActiveColor;
@property XTHtmlColor *bodyLinkVisitedColor;

@property XTHtmlColor *gridModeForegroundColor;
@property XTHtmlColor *gridModeBackgroundColor;
@property XTHtmlColor *gridModeScreenColor;

+ (instancetype)forTextView:(XTTextView *)textView
					isForT3:(BOOL)isForT3
				isForBanner:(BOOL)isForBanner
			isForGridBanner:(BOOL)isForGridBanner;

- (NSColor *)getPrefsOutputTextColor;

- (XTOutputTextColorResult *)getLinkColorResult;

- (XTOutputTextColorResult *)getOutputTextColor:(XTFormattingSpecificationForHtmlTag *)formattingSpecForHtmlTag;

- (NSColor *)getPrefsOutputBackgroundColorForTextView;

- (NSColor *)getPrefsOutputBackgroundColorForTextBannerTextView;

- (NSColor *)getOutputBackgroundColorForTextView;

- (XTOutputTextColorResult *)getOutputBackgroundColor:(XTFormattingSpecificationForHtmlTag *)formattingSpecForHtmlTag; // for text

- (void)applyPrefsTextAndInputColors;

- (void)applyTextAndInputColorsForAllowGameToSetColors;

- (void)applyBodyTextAndInputColorsForceApply:(BOOL)forceApply;

- (void)applyBodyLinkColor;

- (void)updateLinkColors;

- (void)updateTableColors;

- (void)updateCursorColor:(XTFormattingSpecificationForHtmlTag *)formattingSpecForHtmlTag;

- (void)resetBodyColors;

- (void)updateLinksUnderline;

- (void)applyMouseOverLink:(XTMouseOnLinkState *)mouseOverLinkState;

- (void)cancelMouseOverLink:(XTMouseOnLinkState *)mouseOverLinkState;

- (void)applyMouseDownOnLink:(XTMouseOnLinkState *)mouseOverLinkState;

- (void)cancelMouseDownOnLink:(XTMouseOnLinkState *)mouseOverLinkState;

- (void)setLinkClickedColorAtCharIndex:(NSUInteger)charIndex;

@end

//NS_ASSUME_NONNULL_END
