//
//  XTOutputFormatterProtocol.h
//  TadsTerp
//
//  Created by Rune Berg on 10/07/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//
//  The methods used to TODO
//

#import <Foundation/Foundation.h>
#import "XTFormattingSpecification.h"
#import "XTTextAlignMode.h"


// Custom attributed string attr keys:
#define XT_OUTPUT_FORMATTER_ATTR_CMDLINK_APPEND @"xtads.cmdlink.append"
#define XT_OUTPUT_FORMATTER_ATTR_CMDLINK_NOENTER @"xtads.cmdlink.noenter"
#define XT_OUTPUT_FORMATTER_ATTR_TEMPATTRSDICT @"xtads.tempAttrsDict"
#define XT_OUTPUT_FORMATTER_ATTR_TAB_ALIGNMENT_SET @"xtads.tabAlignmentSet"

#define XT_OUTPUT_FORMATTER_ATTR_RECOLORABLE_TEXT @"xtads.recolorableText"
#define XT_OUTPUT_FORMATTER_ATTR_RECOLORABLE_TEXT_BACKGROUND  @"xtads.recolorableTextBackground"

#define XT_OUTPUT_FORMATTER_ATTR_PLAIN_LINK @"xtads.plainLink"
#define XT_OUTPUT_FORMATTER_ATTR_UNDERLINE_FROM_PREFS @"xtads.underlineFromPrefs"

@class XTHtmlTag;
@class XTHtmlTagText;
@class XTHtmlTagWhitespace;
@class XTHtmlTagQuotedSpace;
@class XTHtmlTagSpecialSpace;
@class XTHtmlTagNonbreakingSpace;
@class XTHtmlTagBr;
@class XTHtmlTagDiv;
@class XTHtmlTagBlockQuote;
@class XTHtmlTagQ;
@class XTHtmlTagTab;
@class XTHtmlTagP;
@class XTHtmlTagTitle;
@class XTHtmlTagHr;
@class XTHtmlTagSmall;
@class XTHtmlTagBig;
@class XTHtmlTagAboutBox;
@class XTHtmlTagBanner;
@class XTHtmlTagCenter;
@class XTHtmlTagH1;
@class XTHtmlTagH2;
@class XTHtmlTagH3;
@class XTHtmlTagH4;
@class XTHtmlTagOl;
@class XTHtmlTagUl;
@class XTHtmlTagLi;
@class XTHtmlTagNoop;
@class XTHtmlTagQuestionMarkT2;
@class XTHtmlTagQuestionMarkT3;
@class XTHtmlTagTable;
@class XTHtmlTagTr;
@class XTHtmlTagTh;
@class XTHtmlTagTd;
@class XTHtmlTagPre;
@class XTHtmlTagImg;
@class XTHtmlTagBody;
@class XTHtmlTagT2TradStatusLine;
@class XTHtmlTagBannerClear;
@class XTFormattingSpecificationForHtmlTag;


@protocol XTOutputFormatterProtocol <NSObject>

@property XTFormattingSpecificationForHtmlTag *formattingSpecForHtmlTag;

- (BOOL)willProcessTag:(XTHtmlTag *)tag;

- (NSArray *)handleBlockLevelTagEntry:(XTHtmlTag *)tag;
- (NSArray *)handleBlockLevelTagExit:(XTHtmlTag *)tag;

- (NSArray *)handleHtmlTagText:(XTHtmlTagText *)tag;

- (NSArray *)handleHtmlTagWhitespace:(XTHtmlTagWhitespace *)tag;

- (NSArray *)handleHtmlTagQuotedSpace:(XTHtmlTagQuotedSpace *)quotedSpace;

- (NSArray *)handleHtmlTagSpecialSpace:(XTHtmlTagSpecialSpace *)specialSpace;

- (NSArray *)handleHtmlTagNonbreakingSpace:(XTHtmlTagNonbreakingSpace *)nonbreakingSpace;

- (NSArray *)handleHtmlTagBr:(XTHtmlTagBr *)tag;

- (NSArray *)handleHtmlTagQ:(XTHtmlTagQ *)tag;

- (NSArray *)handleHtmlTagTab:(XTHtmlTagTab *)tag;

- (NSMutableAttributedString *)applyTagTab:(XTHtmlTagTab *)tagTab
				forMutableAttributedString:(NSMutableAttributedString *)mutAttrString;

- (NSArray *)handleHtmlTagPOpen:(XTHtmlTagP *)tag;
- (NSArray *)handleHtmlTagPClose:(XTHtmlTagP *)tag;

- (NSArray *)handleHtmlTagTitleOpen:(XTHtmlTagTitle *)tag;
- (NSArray *)handleHtmlTagTitleClose;

- (NSArray *)handleHtmlTagHr:(XTHtmlTagHr *)tag;

- (NSArray *)handleHtmlTagBannerOpen:(XTHtmlTagBanner *)tag;
- (NSArray *)handleHtmlTagBannerClose;

- (NSArray *)handleHtmlTagBannerClear:(XTHtmlTagBannerClear *)tag;

- (NSArray *)handleHtmlTagOlOpen:(XTHtmlTagOl *)tag;

- (NSArray *)handleHtmlTagLiOpen:(XTHtmlTagLi *)tag;
- (NSArray *)handleHtmlTagLiClose:(XTHtmlTagLi *)tag;

- (NSArray *)handleHtmlTagNoop:(XTHtmlTagNoop *)tag;

- (NSArray *)handleHtmlTagQuestionMarkT2:(XTHtmlTagQuestionMarkT2 *)tag;
- (NSArray *)handleHtmlTagQuestionMarkT3:(XTHtmlTagQuestionMarkT3 *)tag;

- (NSArray *)handleHtmlTagTableOpen:(XTHtmlTagTable *)tag;
- (NSArray *)handleHtmlTagTableClose:(XTHtmlTagTable *)tag;

- (NSArray *)handleHtmlTagTrClose:(XTHtmlTagTr *)tag;

- (NSArray *)handleHtmlTagTdOpen;
- (NSArray *)handleHtmlTagTdClose:(XTHtmlTagTd *)tag;

- (NSArray *)handleHtmlTagImg:(XTHtmlTagImg *)tag;

- (NSArray *)handleHtmlTagBody:(XTHtmlTagBody *)tag;

- (void)recalcAllTabStops;

- (XTFormattingSpecification *)getFormattingSpecificationForBasefont;

- (void)setFormattingSpecificationForBasefont:(XTFormattingSpecification *)fmtSpec;

@end
