//
//  XTFormattingSpecification.m
//  XTads
//
//  Created by Rune Berg on 02/06/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTFormattingSpecification.h"
#import "XTAllocDeallocCounter.h"


@interface XTFormattingSpecification ()

@property CGFloat totalHeadIndent;
@property CGFloat totalTailIndent;

@end


@implementation XTFormattingSpecification

@synthesize totalHeadIndent = _totalHeadIndent;
@synthesize totalTailIndent = _totalTailIndent;

+ (instancetype)specificationWithDefaults
{
	XTFormattingSpecification *spec = [XTFormattingSpecification new];
	spec.bold = NO;
	spec.italic = NO;
	spec.underline = NO;
	spec.tt = NO;
	spec.cite = NO;
	spec.code = NO;
	spec.em = NO;
	spec.strong = NO;
	spec.strikethrough = NO;
	spec.superscript = NO;
	spec.subscript = NO;
	spec.t2Hilite = NO;
	spec.t2Italics = NO;
	spec.htmlSize = 3;
	spec.activeTagA = nil;
	spec.htmlFontFaceList = nil;
	spec.listBulletType = XT_LIST_BULLET_TYPE_UNSPECIFIED;
	spec.listLevel = 0;
	spec.inListHeader = NO;
	spec.inListItem = NO;
	spec.inListItemAfterFirstParagraph = NO;
	spec.blockquoteLevel = 0;
	spec.dlLevel = 0;
	spec.dd = NO;
	spec.credit = NO;
	spec.address = NO;
	spec.dfn = NO;
	spec.var = NO;
	spec.verbatim = NO;
	spec.inAboutBox = NO;
	spec.activeTextTable = nil;
	spec.activeTextTableCell = nil;
	spec.tableRowIndexPlusOne = 0;
	spec.tableColumnIndexPlusOne = 0;
	spec.textTableRowHtmlColor = nil;
	spec.textTableCellHtmlColor = nil;
	spec.textAlignMode = XT_TEXT_ALIGN_LEFT;
	spec.isInHeader = NO;
	spec.hasRightAlignedTab = NO;
	spec.totalHeadIndent = 0;
	spec.totalTailIndent = 0.0;
	return spec;
}


+ (instancetype)specificationFrom:(XTFormattingSpecification *)original
{
	XTFormattingSpecification *new = [XTFormattingSpecification new];
	new.bold = original.bold;
	new.italic = original.italic;
	new.underline = original.underline;
	new.tt = original.tt;
	new.cite = original.cite;
	new.code = original.code;
	new.em = original.em;
	new.strong = original.strong;
	new.strikethrough = original.strikethrough;
	new.superscript = original.superscript;
	new.subscript = original.subscript;
	new.t2Hilite = original.t2Hilite;
	new.t2Italics = original.t2Italics;
	new.htmlSize = original.htmlSize;
	new.activeTagA = original.activeTagA;
	new.htmlFontFaceList = original.htmlFontFaceList;
	new.fontColor = original.fontColor;
	new.backgroundColor = original.backgroundColor;
	new.listBulletType = original.listBulletType;
	new.listLevel = original.listLevel;
	new.inListHeader = original.inListHeader;
	new.inListItem = original.inListItem;
	new.inListItemAfterFirstParagraph = original.inListItemAfterFirstParagraph;
	new.blockquoteLevel = original.blockquoteLevel;
	new.dlLevel = original.dlLevel;
	new.dd = original.dd;
	new.credit = original.credit;
	new.address = original.address;
	new.dfn = original.dfn;
	new.var = original.var;
	new.verbatim = original.verbatim;
	new.inAboutBox = original.inAboutBox;
	new.activeTextTable = original.activeTextTable;
	new.activeTextTableCell = original.activeTextTableCell;
	new.tableRowIndexPlusOne = original.tableRowIndexPlusOne;
	new.tableColumnIndexPlusOne = original.tableColumnIndexPlusOne;
	new.textTableRowHtmlColor = original.textTableRowHtmlColor;
	new.textTableCellHtmlColor = original.textTableCellHtmlColor;
	new.textAlignMode = original.textAlignMode;
	new.isInHeader = original.isInHeader;
	new.hasRightAlignedTab = original.hasRightAlignedTab;
	new.totalHeadIndent = original.totalHeadIndent;
	new.totalTailIndent = original.totalTailIndent;
	return new;
}

@synthesize textAlignModeAsString = _textAlignModeAsString;

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

- (NSString *)textAlignModeAsString
{
	NSString *res;
	switch (self.textAlignMode) {
		case XT_TEXT_ALIGN_LEFT:
			res = @"Left";
			break;
		case XT_TEXT_ALIGN_CENTER:
			res = @"Center";
			break;
		case XT_TEXT_ALIGN_RIGHT:
			res = @"Right";
			break;
		case XT_TEXT_ALIGN_JUSTIFY:
			res = @"Justify";
			break;
		case XT_TEXT_ALIGN_UNSPECIFIED:
			res = @"Unspec.";
			break;
		default:
			res = @"???";
			break;
	}
	return res;
}

- (NSInteger)getBaseHtmlSize
{
	return 3;
		//TODO !!! baseHtmlSize can be affect by <BASEFONT>
}

- (void)setTotalHeadIndent:(CGFloat)totalHeadIndent
{
	_totalHeadIndent = round(totalHeadIndent);
}

- (CGFloat)totalHeadIndent
{
	return _totalHeadIndent;
}

- (void)setTotalTailIndent:(CGFloat)totalTailIndent
{
	_totalTailIndent = round(totalTailIndent);
}

- (CGFloat)totalTailIndent
{
	return _totalTailIndent;
}

- (void)resetForNextCommand
{
	self.listLevel = 0;
	self.inListItem = NO;
	//TODO probably more to be done here
}

@end
