//
//  XTRecalcTabStopCommand.m
//  XTads
//
//  Created by Rune Berg on 02/01/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import "XTRecalcTabStopCommand.h"
#import "XTAllocDeallocCounter.h"


@interface XTRecalcTabStopCommand ()

@property NSUInteger idxInTextStorage;
@property NSUInteger tabIndexInParagraph;
@property BOOL reinsertTabForPlaceholder;

@end


@implementation XTRecalcTabStopCommand

@synthesize idxInTextStorage = _idxInTextStorage;
@synthesize tabIndexInParagraph = _tabIndexInParagraph;
@synthesize reinsertTabForPlaceholder = _reinsertTabForPlaceholder;

+ (instancetype)forIdxInTextStorage:(NSUInteger)idxInTextStorage
				tabIndexInParagraph:(NSUInteger)tabIndexInParagraph
		  reinsertTabForPlaceholder:(BOOL)reinsertTabForPlaceholder
{
	XTRecalcTabStopCommand *res = [XTRecalcTabStopCommand new];
	res.idxInTextStorage = idxInTextStorage;
	res.tabIndexInParagraph = tabIndexInParagraph;
	res.reinsertTabForPlaceholder = reinsertTabForPlaceholder;
	return res;
}

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

@end
