//
//  XTHtmlTagDivBase.m
//  XTads
//
//  Created by Rune Berg on 03/07/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTHtmlTagContainer_private.h"
#import "XTHtmlTagDivBase.h"
#import "XTHtmlTagDiv.h"
#import "XTHtmlTagCenter.h"


@implementation XTHtmlTagDivBase

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	res.textAlignMode = [self getTextAlignModeFrom:res.textAlignMode];
	return res;
}

- (void)formatExit:(NSObject<XTOutputFormatterProtocol> *)formatter
	   textHandler:(XTBaseTextHandler *)textHandler
{
	XTHtmlTagContainer *tagContainer = self.formattingSpecForHtmlTag.oldFormattingSpecForHtmlTag.tagContainer;
	if ([tagContainer isKindOfClass:[XTHtmlTagCenter class]] || [tagContainer isKindOfClass:[XTHtmlTagDiv class]]) {
		// nothing - keep container's text alignment
	} else {
		self.formattingSpecForHtmlTag.oldFormattingSpecForHtmlTag.formattingSpec.textAlignMode = XT_TEXT_ALIGN_LEFT;
	}
	
	[super formatExit:formatter textHandler:textHandler];
}

@end
