#include <adv.t>
#include <std.t>

startroom: room
  sdesc = "Jail Cell"
  ldesc = "You are in a small, spartan jail cell that you share with
  your cellmate, Bobby.  Long metal bars stand between you and freedom.
  There is a small red button on one wall. "
;

bobby : Actor
  noun = 'bobby' 'cellmate'
  sdesc = "Bobby"
  adesc = "Bobby"
  thedesc = "Bobby"
  location = startroom
  actorDesc = "Bobby is standing in the corner of the cell, chewing his
  fingernails. "
  
  // If Bobby were a girl, we'd need to change the following properties
  // in order to use the format strings in the example below:
  /*
  fmtYou = "she"
  fmtYour = "her"
  fmtYoure = "she's"
  fmtYoum = "her"
  fmtYouve = "she's"
  */
  
  ldesc = 
  {
    "Bobby is a tall, burly man with large muscles.  At first
    glance, he seems quite intimidating, but you've come to know him as a
    relatively friendly guy. ";
    if (itemcnt(bobby.contents))
    {
      "He's carrying <<listcont(bobby)>>. ";
    }
  }
      
  actorAction(verb, dobj, prep, iobj) =
  {
    // Disallow any commands to this actor by invoking "exit"
    // Doing nothing, or invoking "return" will allow the command.
    
    // First, let's disallow Bobby from doing anything to the player.
    if (dobj == Me || iobj == Me)
    {
      "Bobby says, \"I don't want to do that.  I might accidentally hurt
      you, and you're my friend.\" ";
      exit;
    }
    
    // Let's allow the player to command Bobby to take, drop, and push
    // things, and disallow all other commands.
    switch(verb)
    {
      case takeVerb:
      case dropVerb:
      case pushVerb:
        return;
      default:
        "Bobby shrugs his shoulders and ignores you.  He's clearly not interested in
        doing that. ";
        exit;
    }
  }
;


boulder : item
  location = startroom
  sdesc = "heavy boulder"
  noun = 'boulder'
  adjective = 'heavy'
  ldesc = "The boulder is not particularly large, but it looks massive
  nonetheless.  It would clearly take someone with muscle to lift it. "
  doTake(actor) =
  {
    if (actor == bobby)
    {
      "Bobby lifts the boulder effortlessly. ";
      boulder.moveInto(bobby);
    }
    else
    {
      "You struggle to lift the boulder, but fail. ";
    }
  }
;
  
redbutton : fixeditem
  location = startroom
  sdesc = "red button"
  noun = 'button'
  adjective = 'red'
  ldesc = "This button supposedly rings for a guard. "
  verDoPush(actor) = {}
  doPush(actor) = 
  {
    "%You% push%es% the button, and a bell rings in the distance, but no
    guards come.  %You% %are%n't surprised. ";
  }
  
  // doPush method without format strings looks like this:
  /*
  doPush(actor) =
  {
    if (actor == bobby)
    {
      "He pushes the button, and a bell rings in the distance, but no 
      guards come.  He isn't surprised. ";
    }
    else 
    {
      "You push the button, and a bell rings in the distance, but no
      guards come.  You aren't surprised. ";
    }
  }
  */

;
