#include <World.t>                           /* read in the WorldClass system */

path: Sensor, Outside             /* Note the use of Outside rather than Room */
  sdesc = "Outside cave"
  ldesc = "You're standing in the bright sunlight just outside of a large, dark, foreboding cave, which lies to the north. "
  goNorth = cave                       /* Note that go<direction> is used now */
  verGoSouth(actor) = {            /* Note that verGo<direction> is supported */
    "Adventure beckons; you have no wish to leave. ";
  }
  enter(actor) = {
    if (self.cansee(goldSkull, nil, true) and bones.location <> nil) {
      "As you arrive, the bones suddenly start jiggling with increasing speed until they suddenly rise and form themselves into a skeleton, which is conspicuously missing its skull. ";
      P();
      bones.movein(nil);
      skeleton.movein(path);
    }
    pass enter;
  }
  leave(actor) = {
    if (self.cansee(goldSkull, nil, true) and skeleton.location <> nil) {
      "As you leave, the skeleton collapses, becoming nothing more than a pile of jumbled bones. ";
      P();
      bones.movein(path);
      skeleton.movein(nil);
    }
    pass leave;
  }
;

cave: Room                         /* Note that the Room class is capitalised */
  sdesc = "Cave"
  ldesc = "You're inside a dark and musty cave. Sunlight pours in from a passage to the south. "
  goSouth = path
;

Me: Player                                /* Create a player controlled actor */
  location = path                              /* Give it an initial location */
  locationtype = 'in'                /* the player will be "in" the path room */
  position = 'standing'                        /* the player will be standing */
;

pedestal: Fixture, Surface        /* An unmovable object that can have things */
  noun = 'pedestal'                                            /* put 'on' it */
  heredesc = "A pedestal stands in the centre of the cave. "
  sdesc = "pedestal"
  ldesc = "A large bone-white pedestal rests in the cave centre. It provides no clues as to its original purpose. "
  location = cave
;

modify Item
  weight = 3
  doTake(actor) = {
    if (self.location = pedestal and (pedestal.contentsweight(actor, ['on']) - self.weight) < 3) {
      "\bAs you lift the <<self.subjsdesc>>, a volley of poisonous arrows is shot from the walls! You try to dodge the arrows, but they take you by surprise! ";
      die();
    }
    pass doTake;
  }
;

goldSkull: Item                    /* Note that the Item class is capitalised */
  noun = 'skull' 'head'
  adjective = 'gold'
  sdesc = "skull"
  ldesc = "The skull is of the purest gold, and sparkles in that special way that only gold sparkles like. "
  location = pedestal
  locationtype = 'on'                       /* The skull is 'on' the pedestal */
;

smallRock: Item
  sdesc = "small rock"
  ldesc = "It's a rock; sedimentary to be precise. It's smooth and rounded as if it has been in a river for a long period of time. "
  noun = 'rock'
  adjective = 'small'
  location = cave
;

bones: Fixture
  sdesc = "bones"
  ldesc = "A large jumbled pile of bones, the remains of some poor adventurer no doubt, lie bleaching in the sun. "
  heredesc = "A large jumbled pile of bones lie bleaching in the sun. "
  isplural = true
  noun = 'bones' 'skeleton'
  location = path
;

skeleton: humanActor
  sdesc = "skeleton"
  ldesc = "A large skeleton, minus a skull, stands before you, arm outstretched and waiting, as if for you to give it something. "
  noun = 'skeleton'
  actordesc = self.ldesc
  takesall = nil
  takelist = [goldSkull]
  ioGiveto(actor, dobj) = {
    if (dobj = goldSkull) {
      "The skeleton accepts your gift of the skull, and after attaching it in some manner to its neck, strides off into the sunset. ";
      skeleton.movein(nil);
      goldSkull.movein(nil);
    }
    else
      pass ioGiveto;
  }
;
