/*
 * Mazetst.t
 * Written by Paul Gilbert
 * pfg@yallara.cs.rmit.edu.au
 *
 * This demonstrates the use of the easy solve maze system. It requires the
 * maze2.t unit to compile. It also shows how to correctedly code a room which
 * has multiple entry points into the maze.
 *
 *
 * Usage of this module or of code/therein requires that you give mention to
 * the usage of my module within your code.
 */

#include <world.t>
#include <maze.t>

Me: Player
  location = outroom1
;

maze: Mazeroom
  maxsteps = 3
  exitlocations = [outroom1 outroom2 outroom3]
  sdesc = "Forest"
  ldesc = "You are lost within the forest, in a maze of twisting passageways
    which all look alike."
  leavemaze(actor) =
    {
    local i;

    for (i:=1; i<50; i++)
      {
      local exitdir := rnd(3);
      if (exitlocations[exitdir] <> outlocation)
        return exitlocations[exitdir];
      }
    }
;

outroom1: Room
  sdesc = "Paddock"
  ldesc = "You are in an overgrown paddock, which touches a dense forest to
    the east. The forest seems to be the only direction available, as the
    paddock surmounts a rather large cliff."
  goEast(actor) =
    {
    maze.setexit(self, find(global.dirstringlist, 'east') );
    return maze;
    }
;

//
// This list is needed in outroom2 to correctly find the direction value of
// the direction verb used.
//
modify global
   dirlist =    [&goNorth &goNortheast &goEast &goSoutheast
	 &goNorthwest &goWest &goSouthwest &goSouth]
;

outroom2: Room
  sdesc = "Clearing"
  ldesc = "You have stumbled across an small ancient clearing, deep within the
    forest. Through the ancient branches, the sun struggles feebly to produce
    wan patches of sunlight upon the ground."
  goNowhere(actor) =
    {
    if ( global.lastverb <> upVerb and global.lastverb <> downVerb)
      {
      local dir := find(global.dirlist, global.lastverb.doprop);
      maze.setexit(self, dir);
      return maze;
      }
    else
      {
      "\^<<actor.youll>> have to get
       <<global.locopposites[actor.locationtypenum]>>
       \ <<self.objthedesc(actor)>> first.";
      return nil;
      }
    }
;

outroom3: Room
  sdesc = "River bank"
  ldesc =
    {
    if ( not self.isseen )
      "The forest, at last, lies safely behind you. ";
    "The forest has given way to green fields as far as the eye can see. The
     way is blocked, however, by a large rapid stream, gushing at high speeds
     which make swimming unadvisable. The forest looms back to the west.";
    }
  goWest(actor) =
    {
    maze.setexit(self, find(global.dirstringlist, 'west') );
    return maze;
    }
  verGoEast(actor) =
     { "Images of yourself drowning repel you from making such a foolhardy
        attempt.";
     }
;

modify global
  nondeterministic = true
;
