/*
 * Maze.t
 * Written by Paul Gilbert
 * pfg@yallara.cs.rmit.edu.au
 *
 * This allows easy implementation of a maze in which it doesn't matter which
 * direction you go in. It also maintains a list so that the player can
 * backtrack (in the reverse direction to exit the maze.
 *
 * To use it, declare a maze room as derived from the Mazeroom class, and give
 * it a sdesc and ldesc which reflect that there are exits all around. Set the
 * maxsteps to the number of steps the player can go before leaving the maze.
 * Then whenever the maze is to be entered, call the setexit method with the
 * location which has just been left (before entering the maze), and the
 * direction the maze was entered into, as an offset into the dirstringlist.
 * This allows for proper backtracking out of the maze. You must also provide
 * a leavemaze method which should return a location which the player leaves
 * the maze to.
 *
 * See Mazetst.t for a demonstration of the maze system.
 *
 */

modify global
   dirstringlist =      ['north' 'northeast' 'east' 'southeast'
	 'northwest' 'west' 'southwest' 'south']
   dirlist =    [&goNorth &goNortheast &goEast &goSoutheast
	 &goNorthwest &goWest &goSouthwest &goSouth]
   backtracking = nil
;

;

class Mazeroom: Room
  steps = []
  maxsteps = 5
  outlocation = nil

  goNowhere(actor) =
    {
    if ( global.lastverb <> upVerb and global.lastverb <> downVerb)
      {
      local dir := find(global.dirlist, global.lastverb.doprop);
      return self.move(actor, dir);
      }
    else
      {
      "\^<<actor.subjthedesc>> can't go that way.";
      return nil;
      }
    }

  setexit(loc, dir) =
    {
    self.outlocation := loc;
    self.steps := [dir];
    }

  move(actor, dir) =
    {
    //
    // This is the main routine for moving. It takes care of checking for
    // backtracking, or otherwise adding onto the steps list.
    //

    if ( steps[1] = 9 - dir )
      {
      self.steps := cdr(self.steps);
      if ( self.steps = [] )
	return outlocation;
      global.backtracking := true;
      }
    else
      self.steps := [dir] + self.steps;

    if ( length(steps) > maxsteps )
      return self.leavemaze(actor);
    else
      return self;
    }

  enter(actor) =
    {
    local alreadyknown := self.isknownto(actor) and global.backtracking;

    self.makecontentsknownto(actor);
    self.makeknownto(actor);
    self.lookaround(actor, not alreadyknown or global.verbose);
    self.isseen := true;
    global.backtracking := nil;
    }
;
