/*
 * Sample game to test actor stuff
 * Written by Paul Gilbert
 * pfg@yallra.cs.rmit.edu.au
 */
#include <world.t>

Me: Player
   location = room1
;

room1: Room
  sdesc = "room 1"
  ldesc = "You are in a very boring room. There is a passage to the east and
     south, and an imaginary passage to the west."
  noun = 'room 1'

  goEast  = room2
  goSouth = room4
  verGoWest(actor) =
     { "%You% can't go that way, since %you% <<actor.isnt>> imaginary."; }
;

room2: Room
  sdesc = "room 2"
  ldesc = "You are in a second boring room. Exits are to the south and west."
  noun = 'room 2'

  goSouth = room3
  goWest = room1
;

room3: Room
  sdesc = "room 3"
  ldesc = "This is yet another boring room, with exits to the north & west."
  noun = 'room 3'

  goWest = room4
  goNorth = room2
;

room4: Room
  sdesc = "room 4"
  ldesc = "This is... you guessed it, another boring room, with exits to the
     east and north."
  noun = 'room 4'

  goEast  = room3
  goNorth = room1
;

chair1: Chair
   sdesc = "chair"
   ldesc = "This is a generic sitting-down-on chair."
   location = room1
   noun = 'chair'
;

class Qbehindroom: Nestedroom
	tdesc = {
		if (self.location)
			self.location.tdesc;
		else
			caps();
		", <<global.lastactor.position>>
		\ <<global.lastactor.locationtype>>
		\ <<self.objthedesc(nil)>>";
	}

	verDoExit(actor) = {
		if (not actor.iscontained(self, 'in'))
			"\^<<actor.youre>> not in <<self.objthedesc(actor)>>.";
			   }
	doExit(actor) =
		{
		actor.moveto(self.location, self.locationtype);
		actor.position := 'standing';
		"%You% ";
		if ( actor.isplural ) "leave"; else "leaves";
		" <<self.subjthedesc>>.";
		}
	verGoOut(actor) = { self.verDoExit(actor); }
	goOut(actor) =
                {
		actor.position := 'standing';
		"%You% ";
		if ( actor.isplural ) "leave"; else "leaves";
		" <<self.subjthedesc>>.\b";
                return self.location;
                }
	verDoGetbehind(actor) = {}
	doGetbehind(actor) =
		{
		actor.movebehind(self);
		actor.position := 'standing';
		"\^<<actor.youre>> now standing behind <<self.objthedesc(actor)>>.";
		}
	passcanseein(actor, obj, loctype) = { return nil; }
	passcantouchin(actor, obj, loctype) = { return nil; }
	passcantakein(actor, obj, loctype) = { return nil; }
;

curtain: Qbehindroom, Fixture
   heredesc = "There is a large draped curtain on the north wall."
   sdesc = "curtain"
   ldesc = "This is a large draped curtain which almost entirely covers the north wall."
   noun = 'curtain'
   location = room1
;

monitor: Sensor, Listablesound, Item
  sdesc = "monitor"
  ldesc =
    {
    "This is a deceptively simple looking device. It consists of a small
     rectangular box on which is mounted a small video camera and a speaker";
    if ( self.islistablesound(global.lastactor) )
      " which is currently chirping wildly";
    ".";
    }
  noun = 'monitor' 'box'
  location = room1
  islistablesound(actor) =
    {
    return ( self.cansee(Me, Me.locationtype, true) );
    }
  listlistendesc(actor) = "is chirping wildly!"
  listendesc =
    {
    if ( self.islistablesound(global.lastactor) )
      "The small speaker on the kee monitor is chirping wildly!";
    else
      "There is no sound emerging from the kee monitor.";
    }
;

modify getbehindVerb
   verb = 'hide behind'
;
